/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.utility.FileUtil;
import org.h2gis.utilities.JDBCUtilities;

public class JsonWriteDriver {
    private final Connection connection;

    public JsonWriteDriver(Connection connection) {
        this.connection = connection;
    }

    public void write(ProgressVisitor progress, ResultSet resultSet, File file) throws SQLException, IOException {
        this.write(progress, resultSet, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ProgressVisitor progress, ResultSet rs, File fileName, String encoding) throws SQLException, IOException {
        block66: {
            if (FileUtil.isExtensionWellFormated(fileName, "json")) {
                JsonEncoding jsonEncoding = JsonEncoding.UTF8;
                if (encoding != null) {
                    try {
                        jsonEncoding = JsonEncoding.valueOf((String)encoding);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
                    }
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(fileName);
                    int rowCount = 0;
                    int type = rs.getType();
                    if (type == 1004 || type == 1005) {
                        rs.last();
                        rowCount = rs.getRow();
                        rs.beforeFirst();
                    }
                    ProgressVisitor copyProgress = progress.subProcess(rowCount);
                    try (Statement st = this.connection.createStatement();){
                        JsonFactory jsonFactory = new JsonFactory();
                        JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                        try {
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int numColumns = rsmd.getColumnCount();
                            while (rs.next()) {
                                jsonGenerator.writeStartObject();
                                block57: for (int i = 1; i < numColumns + 1; ++i) {
                                    String column_name = rsmd.getColumnName(i);
                                    switch (rsmd.getColumnType(i)) {
                                        case 2003: {
                                            Object[] values = (Object[])rs.getArray(i).getArray();
                                            if (values == null) continue block57;
                                            jsonGenerator.writeArrayFieldStart(column_name);
                                            for (Object value : values) {
                                                jsonGenerator.writeObject(value);
                                            }
                                            jsonGenerator.writeEndArray();
                                            continue block57;
                                        }
                                        case -5: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getLong(i));
                                            continue block57;
                                        }
                                        case 7: {
                                            jsonGenerator.writeObjectField(column_name, (Object)Float.valueOf(rs.getFloat(i)));
                                            continue block57;
                                        }
                                        case 16: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                            continue block57;
                                        }
                                        case 2004: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBlob(i));
                                            continue block57;
                                        }
                                        case 8: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                            continue block57;
                                        }
                                        case 6: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                            continue block57;
                                        }
                                        case 4: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getInt(i));
                                            continue block57;
                                        }
                                        case -9: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                            continue block57;
                                        }
                                        case 12: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                            continue block57;
                                        }
                                        case 1: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                            continue block57;
                                        }
                                        case -15: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                            continue block57;
                                        }
                                        case -16: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                            continue block57;
                                        }
                                        case -1: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                            continue block57;
                                        }
                                        case -6: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getByte(i));
                                            continue block57;
                                        }
                                        case 5: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getShort(i));
                                            continue block57;
                                        }
                                        case 91: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getDate(i));
                                            continue block57;
                                        }
                                        case 92: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getTime(i));
                                            continue block57;
                                        }
                                        case 93: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getTimestamp(i));
                                            continue block57;
                                        }
                                        case -2: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                            continue block57;
                                        }
                                        case -3: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                            continue block57;
                                        }
                                        case -4: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBinaryStream(i));
                                            continue block57;
                                        }
                                        case -7: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                            continue block57;
                                        }
                                        case 2005: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getClob(i));
                                            continue block57;
                                        }
                                        case 2: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                            continue block57;
                                        }
                                        case 3: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                            continue block57;
                                        }
                                        case 70: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getURL(i));
                                            continue block57;
                                        }
                                        case 2006: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getRef(i));
                                            continue block57;
                                        }
                                        case 2002: {
                                            jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                            continue block57;
                                        }
                                        case 2001: {
                                            jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                            continue block57;
                                        }
                                        case 2000: {
                                            jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                            continue block57;
                                        }
                                        default: {
                                            jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                        }
                                    }
                                }
                                jsonGenerator.writeEndObject();
                                copyProgress.endStep();
                            }
                            copyProgress.endOfProgress();
                            jsonGenerator.flush();
                            jsonGenerator.close();
                            break block66;
                        }
                        finally {
                            rs.close();
                        }
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new SQLException(ex);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex);
                    }
                }
            }
            throw new SQLException("Only .json extension is supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ProgressVisitor progress, String tableName, File fileName, String encoding) throws SQLException, IOException {
        String regex = ".*(?i)\\b(select|from)\\b.*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        if (matcher.find()) {
            if (!tableName.startsWith("(") || !tableName.endsWith(")")) throw new SQLException("The select query must be enclosed in parenthesis: '(SELECT * FROM ORDERS)'.");
            PreparedStatement ps = this.connection.prepareStatement(tableName, 1004, 1007);
            ResultSet resultSet = ps.executeQuery();
            this.write(progress, resultSet, fileName, encoding);
            return;
        }
        if (!FileUtil.isExtensionWellFormated(fileName, "json")) throw new SQLException("Only .json extension is supported");
        FileOutputStream fos = null;
        try {
            JsonEncoding jsonEncoding = JsonEncoding.UTF8;
            if (encoding != null) {
                try {
                    jsonEncoding = JsonEncoding.valueOf((String)encoding);
                }
                catch (IllegalArgumentException ex) {
                    throw new SQLException("Only UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, UTF-32LE encoding is supported");
                }
            }
            fos = new FileOutputStream(fileName);
            int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)tableName);
            if (recordCount <= 0) return;
            try (Statement st = this.connection.createStatement();){
                JsonFactory jsonFactory = new JsonFactory();
                JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), jsonEncoding);
                try (ResultSet rs = st.executeQuery(String.format("select * from %s", tableName));){
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int numColumns = rsmd.getColumnCount();
                    ProgressVisitor copyProgress = progress.subProcess(recordCount);
                    while (rs.next()) {
                        jsonGenerator.writeStartObject();
                        block57: for (int i = 1; i < numColumns + 1; ++i) {
                            String column_name = rsmd.getColumnName(i);
                            switch (rsmd.getColumnType(i)) {
                                case 2003: {
                                    Object[] values = (Object[])rs.getArray(i).getArray();
                                    if (values == null) continue block57;
                                    jsonGenerator.writeArrayFieldStart(column_name);
                                    for (Object value : values) {
                                        jsonGenerator.writeObject(value);
                                    }
                                    jsonGenerator.writeEndArray();
                                    continue block57;
                                }
                                case -5: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getLong(i));
                                    continue block57;
                                }
                                case 7: {
                                    jsonGenerator.writeObjectField(column_name, (Object)Float.valueOf(rs.getFloat(i)));
                                    continue block57;
                                }
                                case 16: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                    continue block57;
                                }
                                case 2004: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBlob(i));
                                    continue block57;
                                }
                                case 8: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                    continue block57;
                                }
                                case 6: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getDouble(i));
                                    continue block57;
                                }
                                case 4: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getInt(i));
                                    continue block57;
                                }
                                case -9: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                    continue block57;
                                }
                                case 12: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                    continue block57;
                                }
                                case 1: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                    continue block57;
                                }
                                case -15: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                    continue block57;
                                }
                                case -16: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getNString(i));
                                    continue block57;
                                }
                                case -1: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                    continue block57;
                                }
                                case -6: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getByte(i));
                                    continue block57;
                                }
                                case 5: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getShort(i));
                                    continue block57;
                                }
                                case 91: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getDate(i));
                                    continue block57;
                                }
                                case 92: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getTime(i));
                                    continue block57;
                                }
                                case 93: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getTimestamp(i));
                                    continue block57;
                                }
                                case -2: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                    continue block57;
                                }
                                case -3: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBytes(i));
                                    continue block57;
                                }
                                case -4: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBinaryStream(i));
                                    continue block57;
                                }
                                case -7: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBoolean(i));
                                    continue block57;
                                }
                                case 2005: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getClob(i));
                                    continue block57;
                                }
                                case 2: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                    continue block57;
                                }
                                case 3: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getBigDecimal(i));
                                    continue block57;
                                }
                                case 70: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getURL(i));
                                    continue block57;
                                }
                                case 2006: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getRef(i));
                                    continue block57;
                                }
                                case 2002: {
                                    jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                    continue block57;
                                }
                                case 2001: {
                                    jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                    continue block57;
                                }
                                case 2000: {
                                    jsonGenerator.writeObjectField(column_name, rs.getObject(i));
                                    continue block57;
                                }
                                default: {
                                    jsonGenerator.writeObjectField(column_name, (Object)rs.getString(i));
                                }
                            }
                        }
                        jsonGenerator.writeEndObject();
                        copyProgress.endStep();
                    }
                    copyProgress.endOfProgress();
                    jsonGenerator.flush();
                    jsonGenerator.close();
                    return;
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }
}

