/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class OSMElement {
    private final SimpleDateFormat dataFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat dataFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final HashMap<String, String> tags = new HashMap();
    private long id;
    private long uid;
    private String user;
    private int version;
    private int changeset;
    private boolean visible;
    private Timestamp timestamp;
    private String name = "";

    public long getID() {
        return this.id;
    }

    public void setId(String id) {
        this.id = Long.valueOf(id);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public long getUID() {
        return this.uid;
    }

    public void setUid(String uid) {
        if (uid != null) {
            this.uid = Long.valueOf(uid);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        if (visible != null) {
            this.visible = Boolean.valueOf(visible);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version != null ? Integer.valueOf(version) : 0;
    }

    public int getChangeSet() {
        return this.changeset;
    }

    public void setChangeset(String changeset) {
        if (changeset != null) {
            this.changeset = Integer.valueOf(changeset);
        }
    }

    public Timestamp getTimeStamp() {
        return this.timestamp;
    }

    public void setTimestamp(String OSMtime) throws SAXException {
        if (OSMtime != null) {
            try {
                this.timestamp = new Timestamp(this.dataFormat1.parse(OSMtime).getTime());
            }
            catch (ParseException ex) {
                try {
                    this.timestamp = new Timestamp(this.dataFormat2.parse(OSMtime).getTime());
                }
                catch (ParseException ex1) {
                    throw new SAXException("Cannot parse the timestamp for the node  :  " + this.getID(), ex);
                }
            }
        }
    }

    public boolean addTag(String key, String value) {
        if (key.equalsIgnoreCase("name")) {
            this.name = value;
            return false;
        }
        this.tags.put(key, value);
        return true;
    }

    public HashMap<String, String> getTags() {
        return this.tags;
    }
}

