/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;

public class ST_UpdateZ
extends DeterministicScalarFunction {
    public ST_UpdateZ() {
        this.addProperty("remarks", "This function replace the z value of (each vertex of) the\n geometric parameter to the corresponding value given by a field.\nThe first argument is used to replace all existing z values.\nThe second argument is a int value. \n Set 1 to replace all z values.\nSet 2 to replace all z values excepted the NaN values.\nSet 3 to replace only the NaN z values.");
    }

    public String getJavaStaticMethod() {
        return "updateZ";
    }

    public static Geometry updateZ(Geometry geometry, double z) throws SQLException {
        return ST_UpdateZ.updateZ(geometry, z, 1);
    }

    public static Geometry updateZ(Geometry geometry, double z, int updateCondition) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (updateCondition == 1 || updateCondition == 2 || updateCondition == 3) {
            Geometry outPut = geometry.copy();
            outPut.apply((CoordinateSequenceFilter)new UpdateZCoordinateSequenceFilter(z, updateCondition));
            return outPut;
        }
        throw new SQLException("Available values are 1, 2 or 3.\nPlease read the description of the function to use it.");
    }

    public static class UpdateZCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;
        private final int condition;

        public UpdateZCoordinateSequenceFilter(double z, int condition) {
            this.z = z;
            this.condition = condition;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (this.condition == 1) {
                seq.setOrdinate(i, 2, this.z);
            } else if (this.condition == 2) {
                Coordinate coord = seq.getCoordinate(i);
                double currentZ = coord.z;
                if (!Double.isNaN(currentZ)) {
                    seq.setOrdinate(i, 2, this.z);
                }
            } else if (this.condition == 3) {
                Coordinate coord = seq.getCoordinate(i);
                double currentZ = coord.z;
                if (Double.isNaN(currentZ)) {
                    seq.setOrdinate(i, 2, this.z);
                }
            } else {
                this.done = true;
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

