/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.factory;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Aggregate;
import org.h2.tools.RunScript;
import org.h2gis.api.Function;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.DriverManager;
import org.h2gis.functions.io.asc.AscRead;
import org.h2gis.functions.io.dbf.DBFRead;
import org.h2gis.functions.io.dbf.DBFWrite;
import org.h2gis.functions.io.geojson.GeoJsonRead;
import org.h2gis.functions.io.geojson.GeoJsonWrite;
import org.h2gis.functions.io.geojson.ST_AsGeoJSON;
import org.h2gis.functions.io.geojson.ST_GeomFromGeoJSON;
import org.h2gis.functions.io.gpx.GPXRead;
import org.h2gis.functions.io.json.JsonWrite;
import org.h2gis.functions.io.kml.KMLWrite;
import org.h2gis.functions.io.kml.ST_AsKml;
import org.h2gis.functions.io.osm.OSMRead;
import org.h2gis.functions.io.osm.ST_OSMDownloader;
import org.h2gis.functions.io.shp.SHPRead;
import org.h2gis.functions.io.shp.SHPWrite;
import org.h2gis.functions.io.tsv.TSVRead;
import org.h2gis.functions.io.tsv.TSVWrite;
import org.h2gis.functions.spatial.affine_transformations.ST_Rotate;
import org.h2gis.functions.spatial.affine_transformations.ST_Scale;
import org.h2gis.functions.spatial.affine_transformations.ST_Translate;
import org.h2gis.functions.spatial.aggregate.ST_Accum;
import org.h2gis.functions.spatial.aggregate.ST_Collect;
import org.h2gis.functions.spatial.aggregate.ST_LineMerge;
import org.h2gis.functions.spatial.buffer.ST_Buffer;
import org.h2gis.functions.spatial.buffer.ST_OffSetCurve;
import org.h2gis.functions.spatial.buffer.ST_RingSideBuffer;
import org.h2gis.functions.spatial.buffer.ST_SideBuffer;
import org.h2gis.functions.spatial.buffer.ST_VariableBuffer;
import org.h2gis.functions.spatial.clean.ST_MakeValid;
import org.h2gis.functions.spatial.convert.ST_AsBinary;
import org.h2gis.functions.spatial.convert.ST_AsEWKB;
import org.h2gis.functions.spatial.convert.ST_AsGML;
import org.h2gis.functions.spatial.convert.ST_AsText;
import org.h2gis.functions.spatial.convert.ST_AsWKT;
import org.h2gis.functions.spatial.convert.ST_Force2D;
import org.h2gis.functions.spatial.convert.ST_Force3D;
import org.h2gis.functions.spatial.convert.ST_Force3DM;
import org.h2gis.functions.spatial.convert.ST_Force4D;
import org.h2gis.functions.spatial.convert.ST_GeomFromGML;
import org.h2gis.functions.spatial.convert.ST_GeomFromText;
import org.h2gis.functions.spatial.convert.ST_GeomFromWKB;
import org.h2gis.functions.spatial.convert.ST_GoogleMapLink;
import org.h2gis.functions.spatial.convert.ST_Holes;
import org.h2gis.functions.spatial.convert.ST_LineFromText;
import org.h2gis.functions.spatial.convert.ST_LineFromWKB;
import org.h2gis.functions.spatial.convert.ST_MLineFromText;
import org.h2gis.functions.spatial.convert.ST_MPointFromText;
import org.h2gis.functions.spatial.convert.ST_MPolyFromText;
import org.h2gis.functions.spatial.convert.ST_Multi;
import org.h2gis.functions.spatial.convert.ST_OSMMapLink;
import org.h2gis.functions.spatial.convert.ST_PointFromText;
import org.h2gis.functions.spatial.convert.ST_PointFromWKB;
import org.h2gis.functions.spatial.convert.ST_PolyFromText;
import org.h2gis.functions.spatial.convert.ST_PolyFromWKB;
import org.h2gis.functions.spatial.convert.ST_ToMultiLine;
import org.h2gis.functions.spatial.convert.ST_ToMultiPoint;
import org.h2gis.functions.spatial.convert.ST_ToMultiSegments;
import org.h2gis.functions.spatial.create.ST_BoundingCircle;
import org.h2gis.functions.spatial.create.ST_BoundingCircleCenter;
import org.h2gis.functions.spatial.create.ST_Expand;
import org.h2gis.functions.spatial.create.ST_Extrude;
import org.h2gis.functions.spatial.create.ST_GeneratePoints;
import org.h2gis.functions.spatial.create.ST_GeneratePointsInGrid;
import org.h2gis.functions.spatial.create.ST_MakeEllipse;
import org.h2gis.functions.spatial.create.ST_MakeEnvelope;
import org.h2gis.functions.spatial.create.ST_MakeGrid;
import org.h2gis.functions.spatial.create.ST_MakeGridPoints;
import org.h2gis.functions.spatial.create.ST_MakeLine;
import org.h2gis.functions.spatial.create.ST_MakePoint;
import org.h2gis.functions.spatial.create.ST_MakePolygon;
import org.h2gis.functions.spatial.create.ST_MinimumBoundingCircle;
import org.h2gis.functions.spatial.create.ST_MinimumRectangle;
import org.h2gis.functions.spatial.create.ST_OctogonalEnvelope;
import org.h2gis.functions.spatial.create.ST_OrientedEnvelope;
import org.h2gis.functions.spatial.create.ST_Point;
import org.h2gis.functions.spatial.create.ST_RingBuffer;
import org.h2gis.functions.spatial.crs.ST_FindUTMSRID;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.functions.spatial.crs.UpdateGeometrySRID;
import org.h2gis.functions.spatial.distance.ST_ClosestCoordinate;
import org.h2gis.functions.spatial.distance.ST_ClosestPoint;
import org.h2gis.functions.spatial.distance.ST_FurthestCoordinate;
import org.h2gis.functions.spatial.distance.ST_LocateAlong;
import org.h2gis.functions.spatial.distance.ST_LongestLine;
import org.h2gis.functions.spatial.distance.ST_MaxDistance;
import org.h2gis.functions.spatial.distance.ST_ProjectPoint;
import org.h2gis.functions.spatial.distance.ST_ShortestLine;
import org.h2gis.functions.spatial.earth.ST_GeometryShadow;
import org.h2gis.functions.spatial.earth.ST_Isovist;
import org.h2gis.functions.spatial.earth.ST_SunPosition;
import org.h2gis.functions.spatial.earth.ST_Svf;
import org.h2gis.functions.spatial.edit.ST_AddPoint;
import org.h2gis.functions.spatial.edit.ST_AddZ;
import org.h2gis.functions.spatial.edit.ST_CollectionExtract;
import org.h2gis.functions.spatial.edit.ST_Densify;
import org.h2gis.functions.spatial.edit.ST_FlipCoordinates;
import org.h2gis.functions.spatial.edit.ST_InsertPoint;
import org.h2gis.functions.spatial.edit.ST_Interpolate3DLine;
import org.h2gis.functions.spatial.edit.ST_MultiplyZ;
import org.h2gis.functions.spatial.edit.ST_Normalize;
import org.h2gis.functions.spatial.edit.ST_RemoveDuplicatedCoordinates;
import org.h2gis.functions.spatial.edit.ST_RemoveHoles;
import org.h2gis.functions.spatial.edit.ST_RemovePoints;
import org.h2gis.functions.spatial.edit.ST_RemoveRepeatedPoints;
import org.h2gis.functions.spatial.edit.ST_Reverse;
import org.h2gis.functions.spatial.edit.ST_Reverse3DLine;
import org.h2gis.functions.spatial.edit.ST_UpdateZ;
import org.h2gis.functions.spatial.edit.ST_ZUpdateLineExtremities;
import org.h2gis.functions.spatial.generalize.ST_PrecisionReducer;
import org.h2gis.functions.spatial.generalize.ST_Simplify;
import org.h2gis.functions.spatial.generalize.ST_SimplifyPreserveTopology;
import org.h2gis.functions.spatial.mesh.ST_ConstrainedDelaunay;
import org.h2gis.functions.spatial.mesh.ST_Delaunay;
import org.h2gis.functions.spatial.mesh.ST_Tessellate;
import org.h2gis.functions.spatial.mesh.ST_Voronoi;
import org.h2gis.functions.spatial.metadata.FindGeometryMetadata;
import org.h2gis.functions.spatial.operators.ST_ConvexHull;
import org.h2gis.functions.spatial.operators.ST_Difference;
import org.h2gis.functions.spatial.operators.ST_Intersection;
import org.h2gis.functions.spatial.operators.ST_SymDifference;
import org.h2gis.functions.spatial.operators.ST_Union;
import org.h2gis.functions.spatial.predicates.ST_Contains;
import org.h2gis.functions.spatial.predicates.ST_Covers;
import org.h2gis.functions.spatial.predicates.ST_Crosses;
import org.h2gis.functions.spatial.predicates.ST_DWithin;
import org.h2gis.functions.spatial.predicates.ST_Disjoint;
import org.h2gis.functions.spatial.predicates.ST_EnvelopesIntersect;
import org.h2gis.functions.spatial.predicates.ST_Equals;
import org.h2gis.functions.spatial.predicates.ST_Intersects;
import org.h2gis.functions.spatial.predicates.ST_OrderingEquals;
import org.h2gis.functions.spatial.predicates.ST_Overlaps;
import org.h2gis.functions.spatial.predicates.ST_Relate;
import org.h2gis.functions.spatial.predicates.ST_Touches;
import org.h2gis.functions.spatial.predicates.ST_Within;
import org.h2gis.functions.spatial.properties.ST_3DArea;
import org.h2gis.functions.spatial.properties.ST_3DLength;
import org.h2gis.functions.spatial.properties.ST_3DPerimeter;
import org.h2gis.functions.spatial.properties.ST_Area;
import org.h2gis.functions.spatial.properties.ST_Boundary;
import org.h2gis.functions.spatial.properties.ST_Centroid;
import org.h2gis.functions.spatial.properties.ST_CompactnessRatio;
import org.h2gis.functions.spatial.properties.ST_CoordDim;
import org.h2gis.functions.spatial.properties.ST_Dimension;
import org.h2gis.functions.spatial.properties.ST_Distance;
import org.h2gis.functions.spatial.properties.ST_DistanceSphere;
import org.h2gis.functions.spatial.properties.ST_EndPoint;
import org.h2gis.functions.spatial.properties.ST_Envelope;
import org.h2gis.functions.spatial.properties.ST_EstimatedExtent;
import org.h2gis.functions.spatial.properties.ST_Explode;
import org.h2gis.functions.spatial.properties.ST_Extent;
import org.h2gis.functions.spatial.properties.ST_ExteriorRing;
import org.h2gis.functions.spatial.properties.ST_GeometryN;
import org.h2gis.functions.spatial.properties.ST_GeometryType;
import org.h2gis.functions.spatial.properties.ST_GeometryTypeCode;
import org.h2gis.functions.spatial.properties.ST_InteriorRingN;
import org.h2gis.functions.spatial.properties.ST_Is3D;
import org.h2gis.functions.spatial.properties.ST_IsClosed;
import org.h2gis.functions.spatial.properties.ST_IsEmpty;
import org.h2gis.functions.spatial.properties.ST_IsRectangle;
import org.h2gis.functions.spatial.properties.ST_IsRing;
import org.h2gis.functions.spatial.properties.ST_IsSimple;
import org.h2gis.functions.spatial.properties.ST_IsValid;
import org.h2gis.functions.spatial.properties.ST_IsValidDetail;
import org.h2gis.functions.spatial.properties.ST_IsValidReason;
import org.h2gis.functions.spatial.properties.ST_Length;
import org.h2gis.functions.spatial.properties.ST_MemSize;
import org.h2gis.functions.spatial.properties.ST_MinimumDiameter;
import org.h2gis.functions.spatial.properties.ST_NPoints;
import org.h2gis.functions.spatial.properties.ST_NumGeometries;
import org.h2gis.functions.spatial.properties.ST_NumInteriorRing;
import org.h2gis.functions.spatial.properties.ST_NumInteriorRings;
import org.h2gis.functions.spatial.properties.ST_NumPoints;
import org.h2gis.functions.spatial.properties.ST_Perimeter;
import org.h2gis.functions.spatial.properties.ST_PointN;
import org.h2gis.functions.spatial.properties.ST_PointOnSurface;
import org.h2gis.functions.spatial.properties.ST_SRID;
import org.h2gis.functions.spatial.properties.ST_StartPoint;
import org.h2gis.functions.spatial.properties.ST_X;
import org.h2gis.functions.spatial.properties.ST_XMax;
import org.h2gis.functions.spatial.properties.ST_XMin;
import org.h2gis.functions.spatial.properties.ST_Y;
import org.h2gis.functions.spatial.properties.ST_YMax;
import org.h2gis.functions.spatial.properties.ST_YMin;
import org.h2gis.functions.spatial.properties.ST_Z;
import org.h2gis.functions.spatial.properties.ST_ZMax;
import org.h2gis.functions.spatial.properties.ST_ZMin;
import org.h2gis.functions.spatial.snap.ST_Snap;
import org.h2gis.functions.spatial.split.ST_LineIntersector;
import org.h2gis.functions.spatial.split.ST_Split;
import org.h2gis.functions.spatial.split.ST_SubDivide;
import org.h2gis.functions.spatial.topography.ST_Drape;
import org.h2gis.functions.spatial.topography.ST_TriangleAspect;
import org.h2gis.functions.spatial.topography.ST_TriangleContouring;
import org.h2gis.functions.spatial.topography.ST_TriangleDirection;
import org.h2gis.functions.spatial.topography.ST_TriangleSlope;
import org.h2gis.functions.spatial.topology.ST_Graph;
import org.h2gis.functions.spatial.topology.ST_Node;
import org.h2gis.functions.spatial.topology.ST_Polygonize;
import org.h2gis.functions.spatial.trigonometry.ST_Azimuth;
import org.h2gis.functions.string.HexToVarBinary;
import org.h2gis.functions.system.DoubleRange;
import org.h2gis.functions.system.H2GISversion;
import org.h2gis.functions.system.IntegerRange;
import org.locationtech.jts.JTSVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2GISFunctions {
    public static final String GEOMETRY_BASE_TYPE = "GEOMETRY";
    private static final Logger LOGGER = LoggerFactory.getLogger(H2GISFunctions.class);

    public static Function[] getBuiltInsFunctions() {
        return new Function[]{new HexToVarBinary(), new ST_GeomFromText(), new ST_Area(), new ST_AsBinary(), new ST_GeometryType(), new ST_PointFromText(), new ST_MPointFromText(), new ST_LineFromText(), new ST_MLineFromText(), new ST_PolyFromText(), new ST_MPolyFromText(), new ST_Dimension(), new ST_AsText(), new ST_AsWKT(), new ST_PolyFromWKB(), new ST_IsEmpty(), new ST_IsSimple(), new ST_Boundary(), new ST_Envelope(), new ST_X(), new ST_Y(), new ST_Z(), new ST_StartPoint(), new ST_EndPoint(), new ST_IsClosed(), new ST_IsRing(), new ST_LineFromWKB(), new ST_Length(), new ST_NumPoints(), new ST_PointN(), new ST_Centroid(), new ST_PointOnSurface(), new ST_Contains(), new ST_ExteriorRing(), new ST_NumInteriorRings(), new ST_NumInteriorRing(), new ST_InteriorRingN(), new ST_NumGeometries(), new ST_GeometryN(), new ST_Equals(), new ST_Disjoint(), new ST_Touches(), new ST_Within(), new ST_Overlaps(), new ST_Crosses(), new ST_Intersects(), new ST_Relate(), new ST_Distance(), new ST_DistanceSphere(), new ST_Intersection(), new ST_Difference(), new ST_Union(), new ST_SymDifference(), new ST_Buffer(), new ST_ConvexHull(), new ST_SRID(), new ST_EnvelopesIntersect(), new ST_Accum(), new ST_Transform(), new ST_SetSRID(), new ST_CoordDim(), new ST_GeometryTypeCode(), new ST_OrderingEquals(), new ST_Is3D(), new ST_PointFromWKB(), new ST_GeomFromWKB(), new DBFRead(), new DBFWrite(), new DriverManager(), new GPXRead(), new GeoJsonRead(), new GeoJsonWrite(), new KMLWrite(), new SHPRead(), new SHPWrite(), new ST_3DLength(), new ST_AddPoint(), new ST_AddZ(), new ST_AsGeoJSON(), new ST_AsKml(), new ST_BoundingCircle(), new ST_BoundingCircleCenter(), new ST_MinimumBoundingCircle(), new ST_ClosestCoordinate(), new ST_ClosestPoint(), new ST_CompactnessRatio(), new ST_ConstrainedDelaunay(), new ST_Covers(), new ST_DWithin(), new ST_Delaunay(), new ST_Densify(), new ST_Expand(), new ST_Explode(), new ST_Extent(), new ST_Extrude(), new ST_FurthestCoordinate(), new ST_Holes(), new ST_Interpolate3DLine(), new ST_IsRectangle(), new ST_IsValid(), new ST_LocateAlong(), new ST_MakeEllipse(), new ST_MakeEnvelope(), new ST_MakeGrid(), new ST_MakeGridPoints(), new ST_MakeLine(), new ST_MakePoint(), new ST_MinimumRectangle(), new ST_MultiplyZ(), new ST_Normalize(), new ST_OctogonalEnvelope(), new ST_Polygonize(), new ST_PrecisionReducer(), new ST_RemoveHoles(), new ST_RemovePoints(), new ST_RemoveRepeatedPoints(), new ST_Reverse(), new ST_Reverse3DLine(), new ST_Rotate(), new ST_Scale(), new ST_Simplify(), new ST_SimplifyPreserveTopology(), new ST_Snap(), new ST_Split(), new ST_ToMultiLine(), new ST_ToMultiPoint(), new ST_ToMultiSegments(), new ST_Translate(), new ST_TriangleAspect(), new ST_TriangleContouring(), new ST_TriangleDirection(), new ST_TriangleSlope(), new ST_UpdateZ(), new ST_XMax(), new ST_XMin(), new ST_YMax(), new ST_YMin(), new ST_ZMax(), new ST_ZMin(), new ST_ZUpdateLineExtremities(), new ST_MinimumDiameter(), new ST_RingBuffer(), new ST_Force2D(), new ST_Force3D(), new ST_Azimuth(), new ST_MakePolygon(), new ST_IsValidReason(), new ST_IsValidDetail(), new ST_LineIntersector(), new ST_OffSetCurve(), new OSMRead(), new ST_OSMDownloader(), new ST_ProjectPoint(), new ST_CollectionExtract(), new DoubleRange(), new IntegerRange(), new ST_SideBuffer(), new ST_RingSideBuffer(), new ST_SunPosition(), new ST_GeometryShadow(), new ST_Voronoi(), new ST_Tessellate(), new ST_LineMerge(), new ST_FlipCoordinates(), new ST_MaxDistance(), new ST_LongestLine(), new ST_Perimeter(), new ST_3DPerimeter(), new ST_3DArea(), new ST_GeomFromGML(), new ST_GeomFromGeoJSON(), new ST_OSMMapLink(), new ST_GoogleMapLink(), new ST_AsGML(), new TSVRead(), new TSVWrite(), new ST_NPoints(), new ST_Graph(), new H2GISversion(), new ST_Collect(), new ST_RemoveDuplicatedCoordinates(), new ST_MakeValid(), new ST_Point(), new ST_Node(), new ST_Drape(), new ST_Svf(), new JsonWrite(), new ST_ShortestLine(), new ST_OrientedEnvelope(), new ST_Isovist(), new ST_EstimatedExtent(), new ST_FindUTMSRID(), new ST_GeneratePoints(), new ST_GeneratePointsInGrid(), new AscRead(), new FindGeometryMetadata(), new UpdateGeometrySRID(), new ST_InsertPoint(), new org.h2gis.functions.system.JTSVersion(), new ST_Force4D(), new ST_Force3DM(), new ST_VariableBuffer(), new ST_SubDivide(), new ST_MemSize(), new ST_Multi(), new ST_AsEWKB()};
    }

    public static void load(Connection connection, String BundleSymbolicName, String BundleVersion) throws SQLException {
        String packagePrepend = BundleSymbolicName + ":" + BundleVersion + ":";
        H2GISFunctions.registerH2GISFunctions(connection, packagePrepend);
        H2GISFunctions.registerSpatialTables(connection);
    }

    public static void load(Connection connection) throws SQLException {
        JTSVersion jtsVersion = JTSVersion.CURRENT_VERSION;
        if (jtsVersion.getMinor() < 18) {
            LOGGER.warn("Some spatial functions will not be compatible with your version of JTS (" + jtsVersion.toString() + ")\nPlease a JTS version greater or equals to 1.18");
        }
        H2GISFunctions.registerH2GISFunctions(connection, "");
        H2GISFunctions.registerSpatialTables(connection);
    }

    public static void registerSpatialTables(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        st.execute("drop view if exists geometry_columns");
        st.execute("CREATE VIEW geometry_columns AS SELECT  TABLE_CATALOG f_table_catalog,  TABLE_SCHEMA f_table_schema,  TABLE_NAME f_table_name,  COLUMN_NAME f_geometry_column, 1 storage_type, CAST(FindGeometryMetadata(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME, DATA_TYPE, GEOMETRY_TYPE,GEOMETRY_SRID)[1] AS INTEGER) as geometry_type, CAST(FindGeometryMetadata(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME,DATA_TYPE, GEOMETRY_TYPE,GEOMETRY_SRID)[2] AS INTEGER) as coord_dimension, CAST(FindGeometryMetadata(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME,DATA_TYPE, GEOMETRY_TYPE,GEOMETRY_SRID)[3] AS INTEGER) as srid, FindGeometryMetadata(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME, DATA_TYPE, GEOMETRY_TYPE,GEOMETRY_SRID)[4] as type  FROM INFORMATION_SCHEMA.COLUMNS WHERE DATA_TYPE = 'GEOMETRY';");
        ResultSet rs = connection.getMetaData().getTables("", "PUBLIC", "SPATIAL_REF_SYS", null);
        if (!rs.next()) {
            InputStreamReader reader = new InputStreamReader(H2GISFunctions.class.getResourceAsStream("spatial_ref_sys.sql"));
            RunScript.execute((Connection)connection, (Reader)reader);
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getStringProperty(Function function, String propertyKey) {
        Object value = function.getProperty(propertyKey);
        return value instanceof String ? (String)value : "";
    }

    private static boolean getBooleanProperty(Function function, String propertyKey, boolean defaultValue) {
        Object value = function.getProperty(propertyKey);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static void registerFunction(Statement st, Function function, String packagePrepend) throws SQLException {
        H2GISFunctions.registerFunction(st, function, packagePrepend, true);
    }

    public static void registerFunction(Statement st, Function function, String packagePrepend, boolean dropAlias) throws SQLException {
        String functionClass = function.getClass().getName();
        String functionAlias = H2GISFunctions.getAlias(function);
        if (function instanceof ScalarFunction) {
            ScalarFunction scalarFunction = (ScalarFunction)function;
            String functionName = scalarFunction.getJavaStaticMethod();
            if (dropAlias) {
                try {
                    st.execute("DROP ALIAS IF EXISTS " + functionAlias);
                }
                catch (SQLException ex) {
                    LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            String deterministic = "";
            if (H2GISFunctions.getBooleanProperty(function, "deterministic", false)) {
                deterministic = " DETERMINISTIC";
            }
            st.execute("CREATE FORCE ALIAS IF NOT EXISTS " + functionAlias + deterministic + " FOR \"" + packagePrepend + functionClass + "." + functionName + "\"");
            String functionRemarks = H2GISFunctions.getStringProperty(function, "remarks");
            if (!functionRemarks.isEmpty()) {
                PreparedStatement ps = st.getConnection().prepareStatement("COMMENT ON ALIAS " + functionAlias + " IS ?");
                ps.setString(1, functionRemarks);
                ps.execute();
            }
        } else if (function instanceof Aggregate) {
            if (dropAlias) {
                st.execute("DROP AGGREGATE IF EXISTS " + functionAlias);
            }
            st.execute("CREATE FORCE AGGREGATE IF NOT EXISTS " + functionAlias + " FOR \"" + packagePrepend + functionClass + "\"");
        } else {
            throw new SQLException("Unsupported function " + functionClass);
        }
    }

    public static String getAlias(Function function) {
        String functionAlias = H2GISFunctions.getStringProperty(function, "name");
        if (!functionAlias.isEmpty()) {
            return functionAlias;
        }
        return function.getClass().getSimpleName();
    }

    public static void unRegisterFunction(Statement st, Function function) throws SQLException {
        String functionAlias = H2GISFunctions.getStringProperty(function, "name");
        if (functionAlias.isEmpty()) {
            functionAlias = function.getClass().getSimpleName();
        }
        st.execute("DROP ALIAS IF EXISTS " + functionAlias);
    }

    private static void registerH2GISFunctions(Connection connection, String packagePrepend) throws SQLException {
        Statement st = connection.createStatement();
        for (Function function : H2GISFunctions.getBuiltInsFunctions()) {
            try {
                H2GISFunctions.registerFunction(st, function, packagePrepend);
            }
            catch (SQLException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public static void unRegisterH2GISFunctions(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        for (Function function : H2GISFunctions.getBuiltInsFunctions()) {
            H2GISFunctions.unRegisterFunction(st, function);
        }
    }
}

