/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Polygon;

public class ST_Holes
extends DeterministicScalarFunction {
    public ST_Holes() {
        this.addProperty("remarks", "Returns the given geometry's holes as a GeometryCollection.");
    }

    public String getJavaStaticMethod() {
        return "getHoles";
    }

    public static GeometryCollection getHoles(Geometry geom) throws SQLException {
        if (geom != null) {
            if (geom.getDimension() >= 2) {
                ArrayList<Polygon> holes = new ArrayList<Polygon>();
                int size = geom.getNumGeometries();
                for (int i = 0; i < size; ++i) {
                    Geometry subgeom = geom.getGeometryN(i);
                    if (!(subgeom instanceof Polygon)) continue;
                    Polygon polygon = (Polygon)subgeom;
                    int sub_size = polygon.getNumInteriorRing();
                    for (int j = 0; j < sub_size; ++j) {
                        holes.add(geom.getFactory().createPolygon(geom.getFactory().createLinearRing(polygon.getInteriorRingN(j).getCoordinates()), null));
                    }
                }
                return geom.getFactory().createGeometryCollection(holes.toArray(new Geometry[0]));
            }
            return geom.getFactory().createGeometryCollection(null);
        }
        return null;
    }
}

