/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.mesh.DelaunayData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_Tessellate
extends DeterministicScalarFunction {
    public ST_Tessellate() {
        this.addProperty("remarks", "Return the tessellation of a (multi)polygon surface with adaptive triangles\nEx:\n```sql\nSELECT ST_TESSELLATE('POLYGON ((-6 -2, -8 2, 0 8, -8 -7, -10 -1, -6 -2))') the_geom```");
    }

    public String getJavaStaticMethod() {
        return "tessellate";
    }

    private static MultiPolygon tessellatePolygon(Polygon polygon) {
        DelaunayData delaunayData = new DelaunayData();
        delaunayData.put((Geometry)polygon, DelaunayData.MODE.TESSELLATION);
        delaunayData.triangulate();
        return delaunayData.getTriangles();
    }

    public static MultiPolygon tessellate(Geometry geometry) throws IllegalArgumentException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            return ST_Tessellate.tessellatePolygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            int size = geometry.getNumGeometries();
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(size * 2);
            for (int idPoly = 0; idPoly < size; ++idPoly) {
                MultiPolygon triangles = ST_Tessellate.tessellatePolygon((Polygon)geometry.getGeometryN(idPoly));
                int sub_size = triangles.getNumGeometries();
                polygons.ensureCapacity(sub_size);
                for (int idTri = 0; idTri < sub_size; ++idTri) {
                    polygons.add((Polygon)triangles.getGeometryN(idTri));
                }
            }
            return geometry.getFactory().createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        throw new IllegalArgumentException("ST_Tessellate accept only Polygon and MultiPolygon types not instance of " + geometry.getClass().getSimpleName());
    }
}

