/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.oneOf;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.function.Fn1;
import org.organicdesign.fp.type.RuntimeTypes;

public abstract class OneOf4<A, B, C, D> {
    @NotNull
    protected final Object item;
    private final int sel;
    @NotNull
    private final ImList<Class> types;

    protected OneOf4(@NotNull Object o, @NotNull Class<A> aClass, @NotNull Class<B> bClass, @NotNull Class<C> cClass, @NotNull Class<D> dClass, int index) {
        this.types = RuntimeTypes.registerClasses(aClass, bClass, cClass, dClass);
        this.sel = index;
        this.item = o;
        if (index < 0) {
            throw new IllegalArgumentException("Selected item index must be 0-3");
        }
        if (index > 3) {
            throw new IllegalArgumentException("Selected item index must be 0-3");
        }
        if (!((Class)this.types.get(index)).isInstance(o)) {
            throw new ClassCastException("You specified index " + index + ", indicating a(n) " + ((Class)this.types.get(index)).getCanonicalName() + ", but passed a " + o.getClass().getCanonicalName());
        }
    }

    public <R> R match(@NotNull Fn1<A, R> fa, @NotNull Fn1<B, R> fb, @NotNull Fn1<C, R> fc, @NotNull Fn1<D, R> fd) {
        if (this.sel == 0) {
            return fa.apply(this.item);
        }
        if (this.sel == 1) {
            return fb.apply(this.item);
        }
        if (this.sel == 2) {
            return fc.apply(this.item);
        }
        return fd.apply(this.item);
    }

    public int hashCode() {
        return Objects.hashCode(this.item) + this.sel;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OneOf4)) {
            return false;
        }
        OneOf4 that = (OneOf4)other;
        return this.sel == that.sel && Objects.equals(this.item, that.item);
    }

    @NotNull
    public String toString() {
        return RuntimeTypes.union2Str(this.item, this.types);
    }
}

