/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.acs.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import org.overlord.bam.active.collection.AbstractACSLoader;
import org.overlord.bam.active.collection.ActiveCollectionManager;
import org.overlord.bam.active.collection.ActiveCollectionSource;
import org.overlord.bam.active.collection.util.ActiveCollectionUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEACSLoader
extends AbstractACSLoader {
    private static final Logger LOG = Logger.getLogger(JEEACSLoader.class.getName());
    private static final String ACS_JSON = "acs.json";
    private static final String ACT_COLL_MANAGER = "java:global/overlord-bam/ActiveCollectionManager";
    private ActiveCollectionManager _acmManager = null;
    private List<ActiveCollectionSource> _activeCollectionSources = null;

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this._acmManager = (ActiveCollectionManager)ctx.lookup(ACT_COLL_MANAGER);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(ACS_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activeCollectionSources = ActiveCollectionUtil.deserializeACS((byte[])b);
                if (this._activeCollectionSources == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-LOADER-JEE-2"));
                } else {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this.preInit(acs);
                        this._acmManager.register(acs);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-LOADER-JEE-3"), e);
        }
    }

    @PreDestroy
    public void close() {
        if (this._acmManager != null && this._activeCollectionSources != null) {
            try {
                for (ActiveCollectionSource acs : this._activeCollectionSources) {
                    this._acmManager.unregister(acs);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-LOADER-JEE-4"), e);
            }
        }
    }
}

