/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.processor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.jaxen.javabean.JavaBeanXPath;
import org.overlord.bam.activity.processor.ExpressionEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathExpressionEvaluator
extends ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(XPathExpressionEvaluator.class.getName());
    private DOMXPath _domXPath = null;
    private JavaBeanXPath _beanXPath = null;
    private Map<String, String> _namespaces = new HashMap<String, String>();

    public void setNamespaces(Map<String, String> namespaces) {
        this._namespaces = namespaces;
    }

    public Map<String, String> getNamespaces() {
        return this._namespaces;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this._domXPath = new DOMXPath(this.getExpression());
        this._beanXPath = new JavaBeanXPath(this.getExpression());
        if (this._namespaces != null) {
            this._domXPath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this._namespaces));
        }
    }

    @Override
    public String evaluate(Object information) {
        String ret = null;
        try {
            if (information instanceof String) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream is = new ByteArrayInputStream(((String)information).getBytes());
                Document doc = builder.parse(is);
                ((InputStream)is).close();
                ret = this._domXPath.stringValueOf((Object)doc.getDocumentElement());
            } else {
                ret = information instanceof Node ? this._domXPath.stringValueOf(information) : this._beanXPath.stringValueOf(information);
            }
            if (ret != null && ret.length() == 0) {
                ret = null;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-6"), this.getExpression()), e);
        }
        return ret;
    }
}

