/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.eap.extensions.deploy;

import java.io.File;
import java.net.URL;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.overlord.commons.eap.extensions.deploy.DeploymentDefinition;
import org.overlord.commons.eap.extensions.deploy.SubsystemLogger;
import org.overlord.commons.eap.extensions.deploy.SubsystemMessages;

public class DeploymentAdd
extends AbstractAddStepHandler {
    static final DeploymentAdd INSTANCE = new DeploymentAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        model.setEmptyObject();
        for (SimpleAttributeDefinition attr : DeploymentDefinition.ALL_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
        if (this.requiresRuntime(context)) {
            String name = model.get("name").asString();
            String moduleName = model.get("module").asString();
            ModelNode versionNode = model.get("version");
            String moduleVersion = versionNode.isDefined() ? versionNode.asString() : null;
            SubsystemLogger.ROOT_LOGGER.deploymentInformation(name, moduleName, versionNode);
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.create((String)moduleName, (String)moduleVersion);
            SubsystemLogger.ROOT_LOGGER.locatingModule(moduleIdentifier);
            try {
                Module module = Module.getBootModuleLoader().loadModule(moduleIdentifier);
                SubsystemLogger.ROOT_LOGGER.loadModule(moduleIdentifier);
                PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
                ModelNode op = Util.createOperation((String)"add", (PathAddress)deploymentAddress);
                op.get("enabled").set(true);
                op.get("persistent").set(false);
                URL url = module.getExportedResource(name);
                if (url == null) {
                    throw SubsystemMessages.MESSAGES.couldNotLocateDeployment(moduleIdentifier, name);
                }
                File deployment = new File(url.toURI());
                SubsystemLogger.ROOT_LOGGER.deploymentURL(url);
                ModelNode contentItem = new ModelNode();
                if (deployment.isDirectory()) {
                    contentItem.get("path").set(deployment.getAbsolutePath());
                    contentItem.get("archive").set(false);
                } else {
                    contentItem.get("url").set(url.toExternalForm());
                }
                op.get("content").add(contentItem);
                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                OperationStepHandler handler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
                context.addStep(op, handler, OperationContext.Stage.MODEL);
                context.stepCompleted();
            }
            catch (ModuleLoadException mle) {
                SubsystemLogger.ROOT_LOGGER.failedToLoadModule(mle, moduleIdentifier);
                throw SubsystemMessages.MESSAGES.failedToLoadModule(mle, moduleIdentifier);
            }
            catch (Exception e) {
                throw new OperationFailedException("Deployments failed", (Throwable)e);
            }
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

