/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.activity.model.Context;

public class Situation
implements Externalizable {
    private static final int VERSION = 1;
    private String _type = null;
    private String _subject = null;
    private String _description = null;
    private long _timestamp = 0L;
    private Severity _severity = null;
    private List<ActivityTypeId> _activityTypeIds = new ArrayList<ActivityTypeId>();
    private Map<String, String> _properties = new HashMap<String, String>();
    private List<Context> _contexts = new ArrayList<Context>();

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public void setSeverity(Severity severity) {
        this._severity = severity;
    }

    public void setActivityTypeIds(List<ActivityTypeId> activityTypeIds) {
        this._activityTypeIds = activityTypeIds;
    }

    public List<ActivityTypeId> getActivityTypeIds() {
        return this._activityTypeIds;
    }

    public void setProperties(Map<String, String> props) {
        this._properties = props;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public void setContext(List<Context> context) {
        this._contexts = context;
    }

    public List<Context> getContext() {
        return this._contexts;
    }

    public static Severity getHighestSeverity(List<Situation> sits) {
        Severity ret = null;
        for (Situation s : sits) {
            if (ret == null) {
                ret = s.getSeverity();
                continue;
            }
            if (s.getSeverity().ordinal() <= ret.ordinal()) continue;
            ret = s.getSeverity();
        }
        return ret;
    }

    public static List<Situation> getSituationsForSeverity(Severity severity, List<Situation> sits) {
        ArrayList<Situation> ret = new ArrayList<Situation>();
        for (Situation s : sits) {
            if (s.getSeverity() != severity) continue;
            ret.add(s);
        }
        return ret;
    }

    public String toString() {
        return "Situation '" + this._description + "' of type=" + this._type + " subject=" + this._subject + " severity=" + (Object)((Object)this._severity) + " " + new Date(this._timestamp);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(1);
        out.writeObject(this._type);
        out.writeObject(this._subject);
        out.writeObject(this._description);
        out.writeObject((Object)this._severity);
        out.writeLong(this._timestamp);
        out.writeInt(this._activityTypeIds.size());
        for (i = 0; i < this._activityTypeIds.size(); ++i) {
            out.writeObject(this._activityTypeIds.get(i));
        }
        out.writeObject(this._properties);
        out.writeInt(this._contexts.size());
        for (i = 0; i < this._contexts.size(); ++i) {
            out.writeObject(this._contexts.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        in.readInt();
        this._type = (String)in.readObject();
        this._subject = (String)in.readObject();
        this._description = (String)in.readObject();
        this._severity = (Severity)((Object)in.readObject());
        this._timestamp = in.readLong();
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._activityTypeIds.add((ActivityTypeId)in.readObject());
        }
        this._properties = (Map)in.readObject();
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
    }

    public static enum Severity {
        Low,
        Medium,
        High,
        Critical;

    }
}

