/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.analytics.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.overlord.rtgov.activity.model.ActivityTypeId;
import org.overlord.rtgov.analytics.service.InvocationDefinition;
import org.overlord.rtgov.analytics.service.InvocationMetric;

public abstract class MEPDefinition
implements Externalizable {
    private static final int VERSION = 1;
    private ActivityTypeId _requestId = null;
    private ActivityTypeId _responseId = null;
    private Map<String, String> _properties = new HashMap<String, String>();
    private List<InvocationDefinition> _invocations = new ArrayList<InvocationDefinition>();
    private InvocationMetric _metrics = new InvocationMetric();

    public MEPDefinition() {
    }

    public MEPDefinition(MEPDefinition md) {
        this._requestId = md.getRequestId();
        this._responseId = md.getResponseId();
        this._properties.putAll(md.getProperties());
        for (InvocationDefinition id : md.getInvocations()) {
            this._invocations.add(new InvocationDefinition(id));
        }
        if (md.getMetrics() != null) {
            this._metrics = new InvocationMetric(md.getMetrics());
        }
    }

    public void setRequestId(ActivityTypeId id) {
        this._requestId = id;
    }

    public ActivityTypeId getRequestId() {
        return this._requestId;
    }

    public void setResponseId(ActivityTypeId id) {
        this._responseId = id;
    }

    public ActivityTypeId getResponseId() {
        return this._responseId;
    }

    public void setProperties(Map<String, String> props) {
        this._properties = props;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public void setInvocations(List<InvocationDefinition> invocations) {
        this._invocations = invocations;
    }

    public List<InvocationDefinition> getInvocations() {
        return this._invocations;
    }

    public InvocationDefinition getInvocation(String serviceType, String operation, String fault) {
        for (int i = 0; i < this._invocations.size(); ++i) {
            InvocationDefinition id = this._invocations.get(i);
            if (!id.getServiceType().equals(serviceType) || !id.getOperation().equals(operation) || !(id.getFault() == null ? fault == null : fault != null && id.getFault().equals(fault))) continue;
            return id;
        }
        return null;
    }

    public InvocationMetric getMetrics() {
        return this._metrics;
    }

    protected void setMetrics(InvocationMetric im) {
        this._metrics = im;
    }

    public void merge(MEPDefinition mep) {
        this._requestId = null;
        this._responseId = null;
        this._properties.clear();
        this.getMetrics().merge(mep.getMetrics());
        for (int i = 0; i < mep.getInvocations().size(); ++i) {
            InvocationDefinition id = mep.getInvocations().get(i);
            InvocationDefinition cur = this.getInvocation(id.getServiceType(), id.getOperation(), id.getFault());
            if (cur != null) {
                cur.merge(id);
                continue;
            }
            this.getInvocations().add(new InvocationDefinition(id));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._requestId);
        out.writeObject(this._responseId);
        out.writeObject(this._properties);
        out.writeObject(this._metrics);
        out.writeInt(this._invocations.size());
        for (int i = 0; i < this._invocations.size(); ++i) {
            out.writeObject(this._invocations.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._requestId = (ActivityTypeId)in.readObject();
        this._responseId = (ActivityTypeId)in.readObject();
        this._properties = (Map)in.readObject();
        this._metrics = (InvocationMetric)in.readObject();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._invocations.add((InvocationDefinition)in.readObject());
        }
    }
}

