/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.collector;

import java.util.PropertyResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.collector.ActivityUnitLogger;
import org.overlord.rtgov.activity.collector.CollectorContext;
import org.overlord.rtgov.activity.interceptor.ActivityInterceptorManager;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Origin;
import org.overlord.rtgov.activity.processor.InformationProcessorManager;

public class AbstractActivityCollector
implements ActivityCollector {
    private static final Logger LOG = Logger.getLogger(AbstractActivityCollector.class.getName());
    @Inject
    private CollectorContext _collectorContext = null;
    @Inject
    private ActivityUnitLogger _activityLogger = null;
    @Inject
    private InformationProcessorManager _infoProcessorManager = null;
    @Inject
    private ActivityInterceptorManager _activityInterceptorManager = null;
    private ThreadLocal<ActivityUnit> _activityUnit = new ThreadLocal();

    public void setCollectorContext(CollectorContext cc) {
        this._collectorContext = cc;
    }

    public CollectorContext getCollectorContext() {
        return this._collectorContext;
    }

    public void setActivityUnitLogger(ActivityUnitLogger activityLogger) {
        this._activityLogger = activityLogger;
    }

    public ActivityUnitLogger getActivityUnitLogger() {
        return this._activityLogger;
    }

    public InformationProcessorManager getInformationProcessorManager() {
        return this._infoProcessorManager;
    }

    public void setInformationProcessorManager(InformationProcessorManager ipm) {
        this._infoProcessorManager = ipm;
    }

    public ActivityInterceptorManager getActivityInterceptorManager() {
        return this._activityInterceptorManager;
    }

    public void setActivityInterceptorManager(ActivityInterceptorManager aim) {
        this._activityInterceptorManager = aim;
    }

    protected String createTransactionId() {
        return UUID.randomUUID().toString();
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public void startScope() {
        ActivityUnit au = this._activityUnit.get();
        if (au == null) {
            this.startScope(this.createActivityUnit());
        }
    }

    @Override
    public boolean isScopeActive() {
        return this._activityUnit.get() != null;
    }

    protected void startScope(ActivityUnit au) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Start scope");
        }
        this._activityUnit.set(au);
    }

    protected ActivityUnit createActivityUnit() {
        ActivityUnit ret = new ActivityUnit();
        Origin origin = new Origin();
        origin.setHost(this._collectorContext.getHost());
        origin.setNode(this._collectorContext.getNode());
        origin.setThread(Thread.currentThread().getName());
        ret.setOrigin(origin);
        return ret;
    }

    @Override
    public void endScope() {
        ActivityUnit au = this._activityUnit.get();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("End scope for: " + au);
        }
        if (au != null) {
            this._activityLogger.log(au);
            this._activityUnit.remove();
        } else {
            LOG.severe(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-1"));
        }
    }

    @Override
    public String processInformation(String processor, String type, Object info, ActivityType actType) {
        if (this._infoProcessorManager != null) {
            return this._infoProcessorManager.process(processor, type, info, actType);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Information processor manager not specified: unable to process type '" + type + "' info: " + info);
        }
        return null;
    }

    @Override
    public void record(ActivityType actType) throws Exception {
        boolean transactional;
        ActivityUnit au;
        block10: {
            au = this._activityUnit.get();
            if (this._activityInterceptorManager != null) {
                this._activityInterceptorManager.process(actType);
            }
            transactional = true;
            if (au == null) {
                au = this.createActivityUnit();
                TransactionManager tm = this._collectorContext.getTransactionManager();
                if (tm != null) {
                    try {
                        Transaction txn = tm.getTransaction();
                        if (txn != null) {
                            txn.registerSynchronization(new Synchronization(){

                                public void afterCompletion(int arg0) {
                                    AbstractActivityCollector.this.endScope();
                                }

                                public void beforeCompletion() {
                                }
                            });
                            this.startScope(au);
                            break block10;
                        }
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("No transaction available");
                        }
                        transactional = false;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-2"), e);
                        transactional = false;
                    }
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("No transaction manager available");
                    }
                    transactional = false;
                }
            }
        }
        actType.setTimestamp(this.getTimestamp());
        au.getActivityTypes().add(actType);
        if (!transactional) {
            this._activityLogger.log(au);
        }
    }
}

