/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.interceptor.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import org.overlord.rtgov.activity.interceptor.ActivityInterceptor;
import org.overlord.rtgov.activity.interceptor.ActivityInterceptorManager;
import org.overlord.rtgov.activity.util.ActivityInterceptorUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEAILoader {
    private static final Logger LOG = Logger.getLogger(JEEAILoader.class.getName());
    private static final String AI_JSON = "ai.json";
    private static final String AIS_MANAGER = "java:global/overlord-rtgov/ActivityInterceptorManager";
    private ActivityInterceptorManager _aiManager = null;
    private List<ActivityInterceptor> _activityInterceptors = null;

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this._aiManager = (ActivityInterceptorManager)ctx.lookup(AIS_MANAGER);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(AI_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("ai-loader-jee.Messages").getString("AI-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activityInterceptors = ActivityInterceptorUtil.deserializeActivityInterceptorList((byte[])b);
                if (this._activityInterceptors == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("ai-loader-jee.Messages").getString("AI-LOADER-JEE-2"));
                } else {
                    for (ActivityInterceptor ai : this._activityInterceptors) {
                        ai.init();
                        this._aiManager.register(ai);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("ai-loader-jee.Messages").getString("AI-LOADER-JEE-3"), e);
        }
    }

    @PreDestroy
    public void close() {
        if (this._aiManager != null && this._activityInterceptors != null) {
            try {
                for (ActivityInterceptor ai : this._activityInterceptors) {
                    this._aiManager.unregister(ai);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("ai-loader-jee.Messages").getString("AI-LOADER-JEE-4"), e);
            }
        }
    }
}

