/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.processor.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import org.overlord.rtgov.activity.processor.InformationProcessor;
import org.overlord.rtgov.activity.processor.InformationProcessorManager;
import org.overlord.rtgov.activity.util.InformationProcessorUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEIPLoader {
    private static final Logger LOG = Logger.getLogger(JEEIPLoader.class.getName());
    private static final String IP_JSON = "ip.json";
    private static final String IP_MANAGER = "java:global/overlord-rtgov/InformationProcessorManager";
    private InformationProcessorManager _ipManager = null;
    private List<InformationProcessor> _informationProcessors = null;

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx = new InitialContext();
            this._ipManager = (InformationProcessorManager)ctx.lookup(IP_MANAGER);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(IP_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("ip-loader-jee.Messages").getString("IP-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._informationProcessors = InformationProcessorUtil.deserializeInformationProcessorList((byte[])b);
                if (this._informationProcessors == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("ip-loader-jee.Messages").getString("IP-LOADER-JEE-2"));
                } else {
                    for (InformationProcessor ip : this._informationProcessors) {
                        ip.init();
                        this._ipManager.register(ip);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("ip-loader-jee.Messages").getString("IP-LOADER-JEE-3"), e);
        }
    }

    @PreDestroy
    public void close() {
        if (this._ipManager != null && this._informationProcessors != null) {
            try {
                for (InformationProcessor ip : this._informationProcessors) {
                    this._ipManager.unregister(ip);
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("ip-loader-jee.Messages").getString("IP-LOADER-JEE-4"), e);
            }
        }
    }
}

