/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ep.mvel;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mvel2.MVEL;
import org.overlord.rtgov.ep.EventProcessor;
import org.overlord.rtgov.internal.ep.DefaultEPContext;

public class MVELEventProcessor
extends EventProcessor {
    private static final Logger LOG = Logger.getLogger(MVELEventProcessor.class.getName());
    private DefaultEPContext _context = null;
    private String _script = null;
    private Object _scriptExpression = null;

    public void init() throws Exception {
        super.init();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._script);
        if (is == null) {
            throw new Exception("Unable to locate MVEL script '" + this._script + "'");
        }
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        this._scriptExpression = MVEL.compileExpression((String)new String(b));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initialized script=" + this._script + " compiled=" + this._scriptExpression);
        }
        this._context = new DefaultEPContext(this.getServices());
    }

    public String getScript() {
        return this._script;
    }

    public void setScript(String script) {
        this._script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable process(String source, Serializable event, int retriesLeft) throws Exception {
        Serializable ret = null;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process event '" + event + " from source '" + source + "' on MVEL Event Processor '" + this.getScript() + "'");
        }
        if (this._scriptExpression != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("source", source);
            vars.put("event", event);
            vars.put("retriesLeft", retriesLeft);
            vars.put("epc", this._context);
            MVELEventProcessor mVELEventProcessor = this;
            synchronized (mVELEventProcessor) {
                this._context.handle(null);
                MVEL.executeExpression((Object)this._scriptExpression, vars);
                ret = (Serializable)this._context.getResult();
            }
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
        }
        return ret;
    }
}

