/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ep.mvel;

import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mvel2.MVEL;
import org.overlord.rtgov.ep.Predicate;

public class MVELPredicate
extends Predicate {
    private static final Logger LOG = Logger.getLogger(MVELPredicate.class.getName());
    private String _script = null;
    private String _expression = null;
    private Object _compiled = null;

    public void init() throws Exception {
        String expr = this._expression;
        if (expr == null && this._script != null) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._script);
            if (is == null) {
                throw new Exception("Unable to locate MVEL script '" + this._script + "'");
            }
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            expr = new String(b);
        }
        if (expr != null) {
            this._compiled = MVEL.compileExpression((String)expr);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Initialized expression=" + expr);
            }
        } else {
            throw new Exception("No expression or script specified");
        }
    }

    public String getExpression() {
        return this._expression;
    }

    public void setExpression(String expression) {
        this._expression = expression;
    }

    public String getScript() {
        return this._script;
    }

    public void setScript(String script) {
        this._script = script;
    }

    public boolean evaluate(Object event) {
        boolean ret = false;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Evaluate event '" + event + "' on MVEL Predicate " + (this.getScript() != null ? "script=" + this.getScript() : "expression=" + this.getExpression()) + "]");
        }
        if (this._compiled != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("event", event);
            ret = (Boolean)MVEL.executeExpression((Object)this._compiled, vars);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Evaluation result=" + ret);
        }
        return ret;
    }
}

