/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.jee;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveList;
import org.overlord.rtgov.active.collection.ActiveMap;
import org.overlord.rtgov.jee.CollectionManager;

public class DefaultCollectionManager
implements CollectionManager {
    private static final Logger LOG = Logger.getLogger(DefaultCollectionManager.class.getName());
    private static final String ACTIVE_COLLECTION_MANAGER = "java:global/overlord-rtgov/ActiveCollectionManager";
    private ActiveCollectionManager _activeCollectionManager = null;
    private boolean _initialized = false;

    @PostConstruct
    protected void init() {
        if (this._activeCollectionManager == null) {
            try {
                InitialContext ctx = new InitialContext();
                this._activeCollectionManager = (ActiveCollectionManager)ctx.lookup(ACTIVE_COLLECTION_MANAGER);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize active collection manager", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("*********** DefaultCollectionManager Initialized with acm=" + this._activeCollectionManager);
        }
        this._initialized = true;
    }

    @Override
    public ActiveList getList(String name) {
        ActiveCollection ac = this.getCollection(name);
        if (ac instanceof ActiveList) {
            return (ActiveList)ac;
        }
        return null;
    }

    @Override
    public ActiveMap getMap(String name) {
        ActiveCollection ac = this.getCollection(name);
        if (ac instanceof ActiveMap) {
            return (ActiveMap)ac;
        }
        return null;
    }

    protected ActiveCollection getCollection(String name) {
        if (!this._initialized) {
            this.init();
        }
        if (this._activeCollectionManager != null) {
            return this._activeCollectionManager.getActiveCollection(name);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Active collection manager not initialized");
        }
        return null;
    }
}

