/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.switchyard.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.bus.camel.audit.Audit;
import org.switchyard.bus.camel.audit.Auditor;
import org.switchyard.bus.camel.processors.Processors;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

@Audit(value={Processors.TRANSFORMATION})
@Named(value="BAMInterceptor")
public class ExchangeInterceptor
implements Auditor {
    private static final Logger LOG = Logger.getLogger(ExchangeInterceptor.class.getName());
    private static final String ACTIVITY_COLLECTOR = "java:global/overlord-rtgov/ActivityCollector";
    private ActivityCollector _activityCollector = null;
    private boolean _initialized = false;

    @PostConstruct
    protected void init() {
        if (this._activityCollector == null) {
            try {
                InitialContext ctx = new InitialContext();
                this._activityCollector = (ActivityCollector)ctx.lookup(ACTIVITY_COLLECTOR);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize activity collector", e);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("*********** Exchange Interceptor Initialized with collector=" + this._activityCollector);
        }
        this._initialized = true;
    }

    public void afterCall(Processors processor, org.apache.camel.Exchange exch) {
    }

    public void beforeCall(Processors processor, org.apache.camel.Exchange exch) {
        if (!this._initialized) {
            this.init();
        }
        Exchange exchange = (Exchange)exch.getProperty("SwitchYardExchange", Exchange.class);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("********* Exchange=" + exchange);
        }
        if (exchange == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Returning as not a switchyard exchange");
            }
            return;
        }
        if (exchange.getProvider() == null && LOG.isLoggable(Level.FINEST)) {
            LOG.finest("No provider specified - probably an exception: " + exchange.getMessage().getContent());
        }
        if (this._activityCollector != null) {
            String messageId = null;
            String relatesTo = null;
            String contentType = null;
            for (Property p : exchange.getContext().getProperties(Scope.valueOf((String)exchange.getPhase().toString()))) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Switchyard property: name=" + p.getName() + " value=" + p.getValue());
                }
                if (p.getName().equals("org.switchyard.messageId")) {
                    messageId = (String)p.getValue();
                    continue;
                }
                if (p.getName().equals("org.switchyard.relatesTo")) {
                    relatesTo = (String)p.getValue();
                    continue;
                }
                if (!p.getName().equals("org.switchyard.contentType")) continue;
                contentType = ((QName)p.getValue()).toString();
            }
            QName serviceType = exchange.getConsumer().getName();
            String opName = exchange.getContract().getConsumerOperation().getName();
            if (exchange.getPhase() == ExchangePhase.IN) {
                if (exchange.getConsumer().getConsumerMetadata().isBinding()) {
                    this._activityCollector.startScope();
                } else {
                    RequestSent sent = new RequestSent();
                    sent.setServiceType(serviceType.toString());
                    sent.setOperation(opName);
                    sent.setMessageId(messageId);
                    this.record(exchange, contentType, (RPCActivityType)sent);
                }
                if (exchange.getProvider() == null || !exchange.getProvider().getProviderMetadata().isBinding()) {
                    RequestReceived recvd = new RequestReceived();
                    recvd.setServiceType(serviceType.toString());
                    recvd.setOperation(opName);
                    recvd.setMessageId(messageId);
                    this.record(exchange, contentType, (RPCActivityType)recvd);
                }
            } else if (exchange.getPhase() == ExchangePhase.OUT) {
                if (exchange.getProvider() == null || !exchange.getProvider().getProviderMetadata().isBinding()) {
                    ResponseSent sent = new ResponseSent();
                    sent.setServiceType(serviceType.toString());
                    sent.setOperation(opName);
                    sent.setMessageId(messageId);
                    sent.setReplyToId(relatesTo);
                    this.record(exchange, contentType, (RPCActivityType)sent);
                }
                if (exchange.getConsumer().getConsumerMetadata().isBinding()) {
                    this._activityCollector.endScope();
                } else {
                    ResponseReceived recvd = new ResponseReceived();
                    recvd.setServiceType(serviceType.toString());
                    recvd.setOperation(opName);
                    recvd.setMessageId(messageId);
                    recvd.setReplyToId(relatesTo);
                    this.record(exchange, contentType, (RPCActivityType)recvd);
                }
            }
        }
    }

    protected void record(Exchange exchange, String contentType, RPCActivityType at) {
        if (at != null) {
            at.setMessageType(contentType);
            Message msg = exchange.getMessage();
            at.setContent(this._activityCollector.processInformation(null, contentType, msg.getContent(), (ActivityType)at));
            SecurityContext sc = SecurityContext.get((Exchange)exchange);
            if (sc != null) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            try {
                this._activityCollector.record((ActivityType)at);
            }
            catch (Exception e) {
                throw new SwitchYardException(e.getMessage());
            }
        }
    }
}

