/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.services;

import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.util.GenericType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.services.AbstractFeedResource;

@Path(value="/s-ramp")
public class QueryResource
extends AbstractFeedResource {
    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromGet(@Context UriInfo uri, @QueryParam(value="query") String query, @QueryParam(value="page") Integer page, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="ascending") Boolean asc, @QueryParam(value="propertyName") Set<String> propNames) throws SrampAtomException {
        try {
            return this.query(query, page, pageSize, orderBy, asc, propNames);
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromPost(MultipartFormDataInput input) throws SrampAtomException {
        try {
            String query = (String)input.getFormDataPart("query", (GenericType)new GenericType<String>(){});
            Integer page = (Integer)input.getFormDataPart("page", (GenericType)new GenericType<Integer>(){});
            Integer pageSize = (Integer)input.getFormDataPart("pageSize", (GenericType)new GenericType<Integer>(){});
            String orderBy = (String)input.getFormDataPart("orderBy", (GenericType)new GenericType<String>(){});
            Boolean asc = (Boolean)input.getFormDataPart("ascending", (GenericType)new GenericType<Boolean>(){});
            Set propNames = (Set)input.getFormDataPart("propertyName", (GenericType)new GenericType<Set<String>>(){});
            return this.query(query, page, pageSize, orderBy, asc, propNames);
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SrampAtomException(e);
        }
    }

    protected Feed query(String query, Integer page, Integer pageSize, String orderBy, Boolean ascending, Set<String> propNames) throws SrampAtomException {
        if (query == null) {
            throw new SrampAtomException("Missing S-RAMP query (param with name 'query').");
        }
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        return this.createArtifactFeed(xpath, page, pageSize, orderBy, ascending, propNames);
    }
}

