/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.providers;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.overlord.sramp.atom.beans.HttpResponseBean;

@Provider
@Produces(value={"message/http"})
@Consumes(value={"message/http"})
public class HttpResponseProvider
implements MessageBodyReader<HttpResponseBean>,
MessageBodyWriter<HttpResponseBean> {
    @Context
    protected Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return HttpResponseBean.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return HttpResponseBean.class.isAssignableFrom(type);
    }

    public long getSize(HttpResponseBean t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(HttpResponseBean t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Object entity = t.getBody();
        Class<?> entityType = entity.getClass();
        MessageBodyWriter entityWriter = this.providers.getMessageBodyWriter(entityType, null, null, t.getBodyType());
        long size = entityWriter.getSize(entity, entityType, null, null, t.getBodyType());
        if (size > -1L) {
            t.setHeader("Content-Length", Integer.toString((int)size));
        }
        t.setHeader("Content-Classname", entityType.getName());
        PrintWriter writer = new PrintWriter(entityStream);
        writer.print("HTTP/1.1 ");
        writer.print(t.getCode());
        writer.print(" ");
        writer.println(t.getStatus());
        for (Map.Entry<String, String> entry : t.getHeaders().entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            writer.print(name);
            writer.print(": ");
            writer.println(value);
        }
        writer.println("");
        writer.flush();
        entityWriter.writeTo(entity, entityType, null, null, t.getBodyType(), null, entityStream);
    }

    public HttpResponseBean readFrom(Class<HttpResponseBean> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String httpStuff = this.consumeHttpHeaders(entityStream);
        BufferedReader reader = new BufferedReader(new StringReader(httpStuff));
        String line1 = reader.readLine();
        if (!line1.startsWith("HTTP/1.1")) {
            throw new IOException("Failed to read an HTTP response (missing HTTP/ prolog).");
        }
        int idx1 = line1.indexOf(32);
        int idx2 = line1.indexOf(32, idx1 + 1);
        int code = Integer.valueOf(line1.substring(idx1 + 1, idx2));
        String status = line1.substring(idx2 + 1);
        HttpResponseBean rval = new HttpResponseBean(code, status);
        String line = reader.readLine();
        while (line != null && !"".equals(line)) {
            int idx = line.indexOf(58);
            String key = line.substring(0, idx).trim();
            String val = line.substring(idx + 1).trim();
            rval.setHeader(key, val);
            line = reader.readLine();
        }
        String contentType = rval.getHeaders().get("Content-Type");
        String contentClassName = rval.getHeaders().get("Content-Classname");
        Class entityClass = String.class;
        try {
            if (contentClassName != null) {
                entityClass = Class.forName(contentClassName);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        MediaType bodyMediaType = MediaType.valueOf((String)contentType);
        MessageBodyReader entityReader = this.providers.getMessageBodyReader(entityClass, null, null, bodyMediaType);
        Object bodyEntity = entityReader.readFrom(entityClass, null, null, bodyMediaType, null, entityStream);
        rval.setBody(bodyEntity, bodyMediaType);
        return rval;
    }

    private String consumeHttpHeaders(InputStream entityStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int newlinecount = 0;
        while (newlinecount != 2) {
            int b = entityStream.read();
            if (b == 10) {
                ++newlinecount;
            } else if (b != 13) {
                newlinecount = 0;
            }
            baos.write(b);
        }
        return new String(baos.toByteArray(), "UTF-8");
    }
}

