/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.jar;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.overlord.sramp.client.jar.DiscoveredArtifact;

public class DiscoveredArtifacts
implements Iterable<DiscoveredArtifact> {
    private Set<DiscoveredArtifact> artifacts = new HashSet<DiscoveredArtifact>();
    private Map<String, DiscoveredArtifact> index = new HashMap<String, DiscoveredArtifact>();

    public void add(File file) {
        DiscoveredArtifact artifact = new DiscoveredArtifact(file);
        this.getArtifacts().add(artifact);
    }

    public void index(File workDir) {
        for (DiscoveredArtifact artifact : this.getArtifacts()) {
            String archivePath = this.determineArchivePath(workDir, artifact.getFile());
            artifact.setArchivePath(archivePath);
            this.index.put(archivePath, artifact);
        }
    }

    private String determineArchivePath(File workDir, File file) {
        String absWorkDirPath = workDir.getAbsolutePath();
        String absFilePath = file.getAbsolutePath();
        if (!absFilePath.startsWith(absFilePath)) {
            throw new RuntimeException("Failed to determine archive path for: " + file.getName());
        }
        String relativeFilePath = absFilePath.substring(absWorkDirPath.length());
        return relativeFilePath.replace('\\', '/');
    }

    @Override
    public Iterator<DiscoveredArtifact> iterator() {
        return this.getArtifacts().iterator();
    }

    protected Set<DiscoveredArtifact> getArtifacts() {
        return this.artifacts;
    }

    protected void setArtifacts(Set<DiscoveredArtifact> artifacts) {
        this.artifacts = artifacts;
    }
}

