/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.SrampConstants;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.ExtendedArtifactType;

public class ArtifactType {
    private ArtifactTypeEnum artifactType;
    private String mimeType;
    private String extendedType;
    private boolean extendedDerivedType;
    private static Map<String, ModelMime> extendedArtifactTypes = new ConcurrentHashMap<String, ModelMime>();

    public static final ArtifactType Document() {
        return new ArtifactType(ArtifactTypeEnum.Document, "application/octet-stream");
    }

    public static final ArtifactType XmlDocument() {
        return new ArtifactType(ArtifactTypeEnum.XmlDocument, "application/xml");
    }

    public static final ArtifactType XsdDocument() {
        return new ArtifactType(ArtifactTypeEnum.XsdDocument, "application/xml");
    }

    public static final ArtifactType WsdlDocument() {
        return new ArtifactType(ArtifactTypeEnum.WsdlDocument, "application/xml");
    }

    public static final ArtifactType PolicyDocument() {
        return new ArtifactType(ArtifactTypeEnum.PolicyDocument, "application/xml");
    }

    public static final ArtifactType Extended(String extendedType, boolean derived) {
        ArtifactType at = new ArtifactType(ArtifactTypeEnum.ExtendedArtifactType, null);
        at.setExtendedType(extendedType);
        at.setExtendedDerivedType(derived);
        return at;
    }

    private ArtifactType(ArtifactTypeEnum artifactType, String mimeType) {
        this.setArtifactType(artifactType);
        if (mimeType == null) {
            mimeType = artifactType == ArtifactTypeEnum.Document ? "application/octet-stream" : "application/xml";
        }
        this.setMimeType(mimeType);
    }

    public BaseArtifactType unwrap(Artifact artifactWrapper) {
        try {
            Method method = Artifact.class.getMethod("get" + this.getArtifactType().getType(), new Class[0]);
            BaseArtifactType artifact = (BaseArtifactType)method.invoke((Object)artifactWrapper, new Object[0]);
            artifact.setArtifactType(this.getArtifactType().getApiType());
            return artifact;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unwrap artifact for type: " + this.getArtifactType().getType(), e);
        }
    }

    public static ArtifactType fromFileExtension(String extension) {
        String ext = extension.toLowerCase();
        if (ext.equals("xml")) {
            return new ArtifactType(ArtifactTypeEnum.XmlDocument, "application/xml");
        }
        if (ext.equals("xsd")) {
            return new ArtifactType(ArtifactTypeEnum.XsdDocument, "application/xml");
        }
        if (ext.equals("wsdl")) {
            return new ArtifactType(ArtifactTypeEnum.WsdlDocument, "application/xml");
        }
        if (ext.equals("wspolicy")) {
            return new ArtifactType(ArtifactTypeEnum.PolicyDocument, "application/xml");
        }
        if (extendedArtifactTypes.containsKey(ext)) {
            ModelMime modelMime = extendedArtifactTypes.get(ext);
            ArtifactType artifactType = ArtifactType.Extended(modelMime.extendedModel, false);
            artifactType.setMimeType(modelMime.mimeType);
            return artifactType;
        }
        return new ArtifactType(ArtifactTypeEnum.Document, null);
    }

    public static ArtifactType valueOf(String artifactType) {
        if (ArtifactTypeEnum.hasEnum(artifactType)) {
            ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.valueOf(artifactType);
            return new ArtifactType(artifactTypeEnum, null);
        }
        ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.ExtendedArtifactType;
        ArtifactType rval = new ArtifactType(artifactTypeEnum, null);
        rval.setExtendedType(artifactType);
        rval.setMimeType("application/octet-stream");
        return rval;
    }

    public static ArtifactType valueOf(String model, String type) {
        ArtifactType artifactType = null;
        if ("ext".equals(model)) {
            ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.ExtendedArtifactType;
            artifactType = new ArtifactType(artifactTypeEnum, null);
            artifactType.setExtendedType(type);
        } else {
            ArtifactTypeEnum artifactTypeEnum = ArtifactTypeEnum.valueOf(type);
            artifactType = new ArtifactType(artifactTypeEnum, null);
        }
        return artifactType;
    }

    public static ArtifactType valueOf(BaseArtifactType artifact) {
        ArtifactTypeEnum[] values;
        BaseArtifactEnum apiType = artifact.getArtifactType();
        if (apiType != null) {
            ArtifactType artifactType = ArtifactType.valueOf(apiType);
            if (DocumentArtifactType.class.isAssignableFrom(artifact.getClass())) {
                artifactType.setMimeType(((DocumentArtifactType)artifact).getContentType());
            }
            if (artifactType.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType) {
                if (artifact.getOtherAttributes().keySet().contains(SrampConstants.SRAMP_CONTENT_TYPE_QNAME)) {
                    String contentTypeStr = (String)artifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME);
                    artifactType.setMimeType(contentTypeStr);
                }
                String extendedType = ((ExtendedArtifactType)artifact).getExtendedType();
                String extendedDerived = (String)artifact.getOtherAttributes().get(SrampConstants.SRAMP_DERIVED_QNAME);
                artifactType.setExtendedType(extendedType);
                artifactType.setExtendedDerivedType("true".equals(extendedDerived));
            }
            return artifactType;
        }
        for (ArtifactTypeEnum artifactTypeEnum : values = ArtifactTypeEnum.values()) {
            if (!artifactTypeEnum.getTypeClass().equals(artifact.getClass())) continue;
            ArtifactType artifactType = new ArtifactType(artifactTypeEnum, null);
            if (artifactTypeEnum == ArtifactTypeEnum.ExtendedArtifactType) {
                if (artifact.getOtherAttributes().keySet().contains(SrampConstants.SRAMP_CONTENT_TYPE_QNAME)) {
                    String contentTypeStr = (String)artifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME);
                    artifactType.setMimeType(contentTypeStr);
                }
                String extendedType = ((ExtendedArtifactType)artifact).getExtendedType();
                String extendedDerived = (String)artifact.getOtherAttributes().get(SrampConstants.SRAMP_DERIVED_QNAME);
                artifactType.setExtendedType(extendedType);
                artifactType.setExtendedDerivedType("true".equals(extendedDerived));
            }
            return artifactType;
        }
        throw new RuntimeException("Could not determine Artifact Type from artifact class: " + artifact.getClass());
    }

    public BaseArtifactType newArtifactInstance() {
        try {
            BaseArtifactType baseArtifactType = this.getArtifactType().getTypeClass().newInstance();
            baseArtifactType.setArtifactType(this.getArtifactType().getApiType());
            if (DocumentArtifactType.class.isAssignableFrom(baseArtifactType.getClass())) {
                ((DocumentArtifactType)baseArtifactType).setContentType(this.getMimeType());
            }
            if (this.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType) {
                baseArtifactType.getOtherAttributes().put(SrampConstants.SRAMP_CONTENT_TYPE_QNAME, this.getMimeType());
                ((ExtendedArtifactType)baseArtifactType).setExtendedType(this.getExtendedType());
            }
            return baseArtifactType;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate Artifact " + this.getArtifactType().getTypeClass(), e);
        }
    }

    public static ArtifactType valueOf(BaseArtifactEnum apiType) {
        ArtifactTypeEnum[] values;
        for (ArtifactTypeEnum artifactType : values = ArtifactTypeEnum.values()) {
            if (artifactType.getApiType() != apiType) continue;
            return new ArtifactType(artifactType, null);
        }
        throw new RuntimeException("Could not determine Artifact Type from S-RAMP API type: " + apiType.value());
    }

    public ArtifactTypeEnum getArtifactType() {
        return this.artifactType;
    }

    public boolean isExtendedType() {
        return this.getArtifactType() == ArtifactTypeEnum.ExtendedArtifactType;
    }

    public boolean isDerived() {
        return this.getArtifactType().isDerived() || this.isExtendedDerivedType();
    }

    public void setArtifactType(ArtifactTypeEnum artifactType) {
        this.artifactType = artifactType;
    }

    public String getModel() {
        return this.getArtifactType().getModel();
    }

    public String getType() {
        if (this.getArtifactType().equals((Object)ArtifactTypeEnum.ExtendedArtifactType)) {
            return this.getExtendedType();
        }
        return this.getArtifactType().getType();
    }

    public String getLabel() {
        return this.getArtifactType().getLabel();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return String.format("/s-ramp/%1$s/%2$s (%3$s)", this.getArtifactType().getModel(), this.getArtifactType().getType(), this.getMimeType());
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public static ArtifactType valueOf(Artifact artifactWrapper) {
        ArtifactType type = null;
        Method[] methods = artifactWrapper.getClass().getMethods();
        try {
            for (Method method : methods) {
                Object o;
                if (!method.getName().startsWith("get") || (o = method.invoke((Object)artifactWrapper, new Object[0])) == null || !BaseArtifactType.class.isAssignableFrom(o.getClass())) continue;
                Class<?> artyClass = ((BaseArtifactType)o).getClass();
                return ArtifactType.valueOf(artyClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static ArtifactType valueOf(Class<? extends BaseArtifactType> artyClass) {
        ArtifactType rval = null;
        for (ArtifactTypeEnum e : ArtifactTypeEnum.values()) {
            if (!e.getTypeClass().equals(artyClass)) continue;
            rval = new ArtifactType(e, null);
        }
        return rval;
    }

    protected boolean isExtendedDerivedType() {
        return this.extendedDerivedType;
    }

    public void setExtendedDerivedType(boolean extendedDerivedType) {
        this.extendedDerivedType = extendedDerivedType;
    }

    static {
        extendedArtifactTypes.put("sramp", new ModelMime("SRAMPDocument", "application/xml"));
        extendedArtifactTypes.put("pkg", new ModelMime("BrmsPkgDocument", "application/octet-stream"));
        extendedArtifactTypes.put("package", new ModelMime("BrmsPkgDocument", "application/octet-stream"));
        extendedArtifactTypes.put("bpmn", new ModelMime("BpmnDocument", "application/xml"));
        extendedArtifactTypes.put("bpmn2", new ModelMime("BpmnDocument", "application/xml"));
        extendedArtifactTypes.put("txt", new ModelMime("TextDocument", "text/plain"));
        extendedArtifactTypes.put("properties", new ModelMime("TextDocument", "text/plain"));
        extendedArtifactTypes.put("css", new ModelMime("CssDocument", "text/css"));
        extendedArtifactTypes.put("html", new ModelMime("HtmlDocument", "text/html"));
        extendedArtifactTypes.put("ftl", new ModelMime("FtlDocument", "text/html"));
        extendedArtifactTypes.put("wid", new ModelMime("TextDocument", "text/plain"));
        extendedArtifactTypes.put("gif", new ModelMime("ImageDocument", "application/octet-stream"));
        extendedArtifactTypes.put("png", new ModelMime("ImageDocument", "application/octet-stream"));
    }

    private static class ModelMime {
        public String extendedModel;
        public String mimeType;

        public ModelMime(String extendedModel, String mimeType) {
            this.extendedModel = extendedModel;
            this.mimeType = mimeType;
        }
    }
}

