/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

import java.text.ParseException;
import org.overlord.sramp.common.query.xpath.CharacterStream;
import org.overlord.sramp.common.query.xpath.TokenStream;
import org.overlord.sramp.common.query.xpath.TokenType;

public class XPathTokenizer {
    public TokenStream tokenize(String input) throws ParseException {
        CharacterStream stream = new CharacterStream(input);
        TokenStream tokens = new TokenStream();
        block7: while (stream.hasNext()) {
            TokenType tokenType;
            int endIndex;
            int startIndex;
            char c = stream.next();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block7;
                }
                case '-': 
                case '.': {
                    if (stream.isNextNumericStart()) {
                        startIndex = stream.index();
                        while (stream.isNextNumeric()) {
                            c = stream.next();
                        }
                        endIndex = stream.index() + 1;
                        tokens.addToken(stream.get(startIndex, endIndex), TokenType.numeric);
                        continue block7;
                    }
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    tokens.addToken(stream.get(stream.index(), stream.index() + 1), TokenType.symbol);
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    startIndex = stream.index();
                    char closingChar = c;
                    boolean foundClosingQuote = false;
                    while (stream.hasNext()) {
                        c = stream.next();
                        if (c == closingChar && stream.isNext(closingChar)) {
                            c = stream.next();
                            continue;
                        }
                        if (c != closingChar) continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        throw new ParseException("No matching closing quote was found.", stream.index());
                    }
                    endIndex = stream.index() + 1;
                    tokens.addToken(stream.get(startIndex, endIndex), TokenType.quotedString);
                    continue block7;
                }
                case '(': {
                    startIndex = stream.index();
                    if (stream.isNext(':')) {
                        while (stream.hasNext() && !stream.areNext(':', ')')) {
                            c = stream.next();
                        }
                        if (stream.hasNext()) {
                            stream.next();
                        }
                        if (!stream.hasNext()) continue block7;
                        stream.next();
                        continue block7;
                    }
                    tokens.addToken(stream.get(stream.index(), stream.index() + 1), TokenType.symbol);
                    continue block7;
                }
            }
            startIndex = stream.index();
            if (this.isValidNcNameStart(c)) {
                tokenType = TokenType.name;
                while (stream.isNextValidXmlNcNameCharacter()) {
                    c = stream.next();
                }
            } else if (this.isValidNumericStart(c)) {
                tokenType = TokenType.numeric;
                while (stream.isNextNumeric()) {
                    c = stream.next();
                }
            } else {
                tokenType = TokenType.other;
                while (stream.isNextValidXmlNcNameCharacter()) {
                    c = stream.next();
                }
            }
            endIndex = stream.index() + 1;
            tokens.addToken(stream.get(startIndex, endIndex), tokenType);
        }
        return tokens.build();
    }

    private boolean isValidNcNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private boolean isValidNumericStart(char c) {
        return Character.isDigit(c);
    }
}

