/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.repository.RepositoryException;
import org.overlord.sramp.repository.jcr.mapper.JCRNodeToArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitorHelper;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public final class JCRNodeToArtifactFactory {
    private JCRNodeToArtifactFactory() {
    }

    public static BaseArtifactType createArtifact(Node jcrNode) {
        try {
            String artifactType = jcrNode.getProperty("sramp:artifactType").getValue().getString();
            return JCRNodeToArtifactFactory.createArtifact(jcrNode, ArtifactType.valueOf((String)artifactType));
        }
        catch (PathNotFoundException e) {
            throw new RuntimeException("JCR Node does not seem to be an s-ramp artifact node.", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseArtifactType createArtifact(Node jcrNode, ArtifactType artifactType) throws RepositoryException {
        try {
            Class artifactClass = artifactType.getArtifactType().getTypeClass();
            BaseArtifactType artifact = (BaseArtifactType)artifactClass.newInstance();
            JCRNodeToArtifactVisitor visitor = new JCRNodeToArtifactVisitor(jcrNode);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return artifact;
        }
        catch (InstantiationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                throw new RepositoryException(e.getCause());
            }
            throw new RepositoryException((Throwable)e);
        }
    }
}

