/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.modeshape.jcr.api.JcrTools;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.repository.DerivedArtifacts;
import org.overlord.sramp.repository.DerivedArtifactsCreationException;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.RepositoryException;
import org.overlord.sramp.repository.jcr.JCRNodeToArtifactFactory;
import org.overlord.sramp.repository.jcr.JCRRepository;
import org.overlord.sramp.repository.jcr.MapToJCRPath;
import org.overlord.sramp.repository.jcr.UpdateJCRNodeFromArtifactVisitor;
import org.overlord.sramp.repository.jcr.util.DeleteOnCloseFileInputStream;
import org.overlord.sramp.repository.jcr.util.JCRUtils;
import org.overlord.sramp.visitors.ArtifactVisitor;
import org.overlord.sramp.visitors.ArtifactVisitorHelper;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.UserDefinedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.XmlDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPersistence
implements PersistenceManager,
DerivedArtifacts {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public BaseArtifactType persistArtifact(String name, ArtifactType artifactType, InputStream content) throws RepositoryException {
        Session session = null;
        try {
            BaseArtifactType baseTypeArtifact;
            session = JCRRepository.getSession();
            JcrTools tools = new JcrTools();
            String uuid = UUID.randomUUID().toString();
            String artifactPath = MapToJCRPath.getArtifactPath(uuid, artifactType);
            this.log.debug("Uploading file {} to JCR.", (Object)name);
            Node artifactNode = tools.uploadFile(session, artifactPath, content);
            JCRUtils.setArtifactContentMimeType(artifactNode, artifactType.getMimeType());
            String jcrMixinName = artifactType.getArtifactType().getApiType().value();
            jcrMixinName = "sramp:" + jcrMixinName.substring(0, 1).toLowerCase() + jcrMixinName.substring(1);
            artifactNode.addMixin(jcrMixinName);
            artifactNode.setProperty("sramp:uuid", uuid);
            artifactNode.setProperty("sramp:name", name);
            artifactNode.setProperty("sramp:artifactModel", artifactType.getArtifactType().getModel());
            artifactNode.setProperty("sramp:artifactType", artifactType.getArtifactType().getType());
            if (UserDefinedArtifactType.class.isAssignableFrom(artifactType.getArtifactType().getTypeClass())) {
                artifactNode.setProperty("sramp:userType", artifactType.getUserType());
            }
            if (XmlDocument.class.isAssignableFrom(artifactType.getArtifactType().getTypeClass())) {
                artifactNode.setProperty("sramp:contentEncoding", "UTF-8");
            }
            this.log.debug("Successfully saved {} to node={}", (Object)name, (Object)uuid);
            session.save();
            if (this.log.isDebugEnabled()) {
                this.printArtifactGraph(uuid, artifactType);
            }
            BaseArtifactType baseArtifactType = baseTypeArtifact = JCRNodeToArtifactFactory.createArtifact(artifactNode, artifactType);
            return baseArtifactType;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
            JCRRepository.logoutQuietly(session);
        }
    }

    public Collection<? extends DerivedArtifactType> createDerivedArtifacts(ArtifactType artifactType, BaseArtifactType artifact) throws DerivedArtifactsCreationException {
        return Collections.emptySet();
    }

    public void persistDerivedArtifact(DerivedArtifactType artifact) {
    }

    public BaseArtifactType getArtifact(String uuid, ArtifactType type) throws RepositoryException {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(uuid, type);
        try {
            session = JCRRepository.getSession();
            if (session.nodeExists(artifactPath)) {
                Node artifactNode = session.getNode(artifactPath);
                BaseArtifactType baseArtifactType = JCRNodeToArtifactFactory.createArtifact(artifactNode, type);
                return baseArtifactType;
            }
            BaseArtifactType artifactNode = null;
            return artifactNode;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    public InputStream getArtifactContent(String uuid, ArtifactType type) throws RepositoryException {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(uuid, type);
        try {
            session = JCRRepository.getSession();
            Node artifactNode = session.getNode(artifactPath);
            Node artifactContentNode = artifactNode.getNode("jcr:content");
            File tempFile = this.saveToTempFile(artifactContentNode);
            DeleteOnCloseFileInputStream deleteOnCloseFileInputStream = new DeleteOnCloseFileInputStream(tempFile);
            return deleteOnCloseFileInputStream;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    public void updateArtifact(BaseArtifactType artifact, ArtifactType type) throws RepositoryException {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(artifact.getUuid(), type);
        try {
            session = JCRRepository.getSession();
            Node artifactNode = session.getNode(artifactPath);
            if (artifactNode == null) {
                throw new RepositoryException("No artifact found with UUID: " + artifact.getUuid());
            }
            UpdateJCRNodeFromArtifactVisitor visitor = new UpdateJCRNodeFromArtifactVisitor(artifactNode);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            if (visitor.hasError()) {
                throw visitor.getError();
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    public void updateArtifactContent(String uuid, ArtifactType artifactType, InputStream content) throws RepositoryException {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(uuid, artifactType);
        try {
            session = JCRRepository.getSession();
            Node artifactNode = session.getNode(artifactPath);
            if (artifactNode == null) {
                throw new RepositoryException("No artifact found with UUID: " + uuid);
            }
            JcrTools tools = new JcrTools();
            tools.uploadFile(session, artifactPath, content);
            session.save();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public void deleteArtifact(String uuid, ArtifactType artifactType) throws RepositoryException {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(uuid, artifactType);
        try {
            session = JCRRepository.getSession();
            if (!session.nodeExists(artifactPath)) {
                throw new RepositoryException("Artifact not found.");
            }
            session.getNode(artifactPath).remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    public List<BaseArtifactType> getArtifacts(ArtifactType type) throws RepositoryException {
        ArrayList<BaseArtifactType> artifacts = new ArrayList<BaseArtifactType>();
        Session session = null;
        String artifactTypePath = MapToJCRPath.getArtifactTypePath(type);
        try {
            session = JCRRepository.getSession();
            Node artifactNode = session.getNode(artifactTypePath);
            ArrayList<Node> collectedNodes = new ArrayList<Node>();
            this.getNodes(artifactNode, collectedNodes);
            for (Node node : collectedNodes) {
                BaseArtifactType artifact = JCRNodeToArtifactFactory.createArtifact(node, type);
                artifacts.add(artifact);
            }
            ArrayList<BaseArtifactType> arrayList = artifacts;
            return arrayList;
        }
        catch (RepositoryException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    private void getNodes(Node node, List<Node> collectedNodes) throws Exception {
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            Node nextNode = nodeIter.nextNode();
            if (this.isArtifactNode(nextNode)) {
                collectedNodes.add(nextNode);
            }
            if (!nextNode.hasNodes()) continue;
            this.getNodes(nextNode, collectedNodes);
        }
    }

    private boolean isArtifactNode(Node node) throws Exception {
        return node.isNodeType("sramp:baseArtifactType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArtifactGraph(String uuid, ArtifactType type) {
        Session session = null;
        String artifactPath = MapToJCRPath.getArtifactPath(uuid, type);
        try {
            session = JCRRepository.getSession();
            Node artifactNode = session.getNode(artifactPath);
            JcrTools tools = new JcrTools();
            tools.printSubgraph(artifactNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            JCRRepository.logoutQuietly(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveToTempFile(Node jcrContentNode) throws Exception {
        File file = File.createTempFile("sramp", ".jcr");
        Binary binary = null;
        InputStream content = null;
        FileOutputStream tempFileOS = null;
        try {
            binary = jcrContentNode.getProperty("jcr:data").getBinary();
            content = binary.getStream();
            tempFileOS = new FileOutputStream(file);
            IOUtils.copy((InputStream)content, (OutputStream)tempFileOS);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            IOUtils.closeQuietly(tempFileOS);
            if (binary != null) {
                binary.dispose();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        IOUtils.closeQuietly((OutputStream)tempFileOS);
        if (binary != null) {
            binary.dispose();
        }
        return file;
    }

    public void shutdown() {
        JCRRepository.shutdown();
    }
}

