/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr.mapper;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.visitors.HierarchicalArtifactVisitorAdapter;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.UserDefinedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.XmlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdType;

public class JCRNodeToArtifactVisitor
extends HierarchicalArtifactVisitorAdapter {
    private Node jcrNode;

    public JCRNodeToArtifactVisitor(Node jcrNode) {
        this.jcrNode = jcrNode;
    }

    protected void visitBase(BaseArtifactType artifact) {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
            BaseArtifactEnum apiType = artifactType.getArtifactType().getApiType();
            artifact.setArtifactType(apiType);
            artifact.setCreatedBy(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:createdBy"));
            XMLGregorianCalendar createdTS = DatatypeFactory.newInstance().newXMLGregorianCalendar(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:created"));
            artifact.setCreatedTimestamp(createdTS);
            artifact.setDescription(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "sramp:description"));
            artifact.setLastModifiedBy(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:lastModifiedBy"));
            XMLGregorianCalendar modifiedTS = DatatypeFactory.newInstance().newXMLGregorianCalendar(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:lastModified"));
            artifact.setLastModifiedTimestamp(modifiedTS);
            artifact.setName(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "sramp:name"));
            artifact.setUuid(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "sramp:uuid"));
            artifact.setVersion(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "version"));
            String srampPropsPrefix = "sramp-properties:";
            int srampPropsPrefixLen = srampPropsPrefix.length();
            PropertyIterator properties = this.jcrNode.getProperties();
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                String propQName = property.getName();
                if (!propQName.startsWith(srampPropsPrefix)) continue;
                String propName = propQName.substring(srampPropsPrefixLen);
                String propValue = property.getValue().getString();
                org.s_ramp.xmlns._2010.s_ramp.Property srampProp = new org.s_ramp.xmlns._2010.s_ramp.Property();
                srampProp.setPropertyName(propName);
                srampProp.setPropertyValue(propValue);
                artifact.getProperty().add(srampProp);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitDerived(DerivedArtifactType artifact) {
    }

    protected void visitWsdlDerived(WsdlDerivedArtifactType artifact) {
    }

    protected void visitXsdDerived(XsdType artifact) {
    }

    protected void visitDocument(DocumentArtifactType artifact) {
        artifact.setContentSize(JCRNodeToArtifactVisitor.getPropertyLength(this.jcrNode, "jcr:content/jcr:data"));
        artifact.setContentType(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:content/jcr:mimeType"));
    }

    protected void visitXmlDocument(XmlDocument artifact) {
        artifact.setContentEncoding(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "sramp:contentEncoding"));
    }

    protected void visitUserDefined(UserDefinedArtifactType artifact) {
        artifact.setUserType(JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "sramp:userType"));
        artifact.getOtherAttributes().put(new QName("s-rampcontentSize"), String.valueOf(JCRNodeToArtifactVisitor.getPropertyLength(this.jcrNode, "jcr:content/jcr:data")));
        artifact.getOtherAttributes().put(new QName("s-rampcontentType"), JCRNodeToArtifactVisitor.getProperty(this.jcrNode, "jcr:content/jcr:mimeType"));
    }

    protected static final String getProperty(Node node, String propertyName) {
        return JCRNodeToArtifactVisitor.getProperty(node, propertyName, null);
    }

    protected static final String getProperty(Node node, String propertyName, String defaultValue) {
        try {
            return node.getProperty(propertyName).getString();
        }
        catch (ValueFormatException e) {
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return defaultValue;
    }

    protected static final Long getPropertyLength(Node node, String propertyName) {
        return JCRNodeToArtifactVisitor.getPropertyLength(node, propertyName, null);
    }

    protected static final Long getPropertyLength(Node node, String propertyName, Long defaultValue) {
        try {
            return node.getProperty(propertyName).getLength();
        }
        catch (ValueFormatException e) {
        }
        catch (PathNotFoundException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return defaultValue;
    }
}

