/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr.query;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.overlord.sramp.query.xpath.visitors.XPathVisitor;
import org.overlord.sramp.repository.jcr.JCRRepository;
import org.overlord.sramp.repository.jcr.query.JCRArtifactSet;
import org.overlord.sramp.repository.jcr.query.SrampToJcrSql2QueryVisitor;
import org.overlord.sramp.repository.query.AbstractSrampQueryImpl;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.QueryExecutionException;

public class JCRSrampQuery
extends AbstractSrampQueryImpl {
    private static Map<String, String> sOrderByMappings = new HashMap<String, String>();

    public JCRSrampQuery(String xpathTemplate, String orderByProperty, boolean orderAscending) {
        super(xpathTemplate, orderByProperty, orderAscending);
    }

    protected ArtifactSet executeQuery(org.overlord.sramp.query.xpath.ast.Query queryModel) throws QueryExecutionException {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            QueryManager jcrQueryManager = session.getWorkspace().getQueryManager();
            String jcrSql2Query = this.createSql2Query(queryModel);
            Query jcrQuery = jcrQueryManager.createQuery(jcrSql2Query, "JCR-SQL2");
            QueryResult jcrQueryResult = jcrQuery.execute();
            NodeIterator jcrNodes = jcrQueryResult.getNodes();
            return new JCRArtifactSet(session, jcrNodes);
        }
        catch (Throwable t) {
            JCRRepository.logoutQuietly(session);
            throw new QueryExecutionException(t);
        }
    }

    private String createSql2Query(org.overlord.sramp.query.xpath.ast.Query queryModel) {
        String jcrPropName;
        String jcrOrderBy = null;
        if (this.getOrderByProperty() != null && (jcrPropName = sOrderByMappings.get(this.getOrderByProperty())) != null) {
            jcrOrderBy = jcrPropName;
        }
        SrampToJcrSql2QueryVisitor visitor = new SrampToJcrSql2QueryVisitor();
        queryModel.accept((XPathVisitor)visitor);
        String sql2Query = visitor.getSql2Query();
        if (jcrOrderBy != null) {
            sql2Query = sql2Query + " ORDER BY [" + jcrOrderBy + "] " + (this.isOrderAscending() ? "ASC" : "DESC");
        }
        return sql2Query;
    }

    static {
        sOrderByMappings.put("createdBy", "jcr:createdBy");
        sOrderByMappings.put("version", "version");
        sOrderByMappings.put("uuid", "sramp:uuid");
        sOrderByMappings.put("createdTimestamp", "jcr:created");
        sOrderByMappings.put("lastModifiedTimestamp", "jcr:lastModified");
        sOrderByMappings.put("lastModifiedBy", "jcr:lastModifiedBy");
        sOrderByMappings.put("name", "sramp:name");
    }
}

