/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.jcr.query;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.overlord.sramp.query.xpath.ast.AndExpr;
import org.overlord.sramp.query.xpath.ast.Argument;
import org.overlord.sramp.query.xpath.ast.ArtifactSet;
import org.overlord.sramp.query.xpath.ast.EqualityExpr;
import org.overlord.sramp.query.xpath.ast.Expr;
import org.overlord.sramp.query.xpath.ast.ForwardPropertyStep;
import org.overlord.sramp.query.xpath.ast.FunctionCall;
import org.overlord.sramp.query.xpath.ast.LocationPath;
import org.overlord.sramp.query.xpath.ast.OrExpr;
import org.overlord.sramp.query.xpath.ast.Predicate;
import org.overlord.sramp.query.xpath.ast.PrimaryExpr;
import org.overlord.sramp.query.xpath.ast.Query;
import org.overlord.sramp.query.xpath.ast.RelationshipPath;
import org.overlord.sramp.query.xpath.ast.SubartifactSet;
import org.overlord.sramp.query.xpath.visitors.XPathVisitor;

public class SrampToJcrSql2QueryVisitor
implements XPathVisitor {
    private StringBuilder builder = new StringBuilder();
    private static Map<QName, String> corePropertyMap = new HashMap<QName, String>();

    public String getSql2Query() {
        return this.builder.toString();
    }

    public void visit(AndExpr node) {
        if (node.getRight() == null) {
            ((OrExpr)node.getLeft()).accept((XPathVisitor)this);
        } else {
            ((OrExpr)node.getLeft()).accept((XPathVisitor)this);
            this.builder.append(" AND ");
            ((AndExpr)node.getRight()).accept((XPathVisitor)this);
        }
    }

    public void visit(Argument node) {
        throw new RuntimeException("Function arguments not yet supported.");
    }

    public void visit(ArtifactSet node) {
        node.getLocationPath().accept((XPathVisitor)this);
    }

    public void visit(EqualityExpr node) {
        if (node.getExpr() != null) {
            this.builder.append(" ( ");
            node.getExpr().accept((XPathVisitor)this);
            this.builder.append(" ) ");
        } else if (node.getOperator() == null) {
            ((ForwardPropertyStep)node.getLeft()).accept((XPathVisitor)this);
            this.builder.append(" LIKE '%'");
        } else {
            ((ForwardPropertyStep)node.getLeft()).accept((XPathVisitor)this);
            this.builder.append(" ");
            this.builder.append(node.getOperator().symbol());
            this.builder.append(" ");
            ((PrimaryExpr)node.getRight()).accept((XPathVisitor)this);
        }
    }

    public void visit(Expr node) {
        node.getAndExpr().accept((XPathVisitor)this);
    }

    public void visit(ForwardPropertyStep node) {
        if (node.getPropertyQName() != null) {
            QName property = node.getPropertyQName();
            if (property.getNamespaceURI() == null || "".equals(property.getNamespaceURI())) {
                property = new QName("http://s-ramp.org/xmlns/2010/s-ramp", property.getLocalPart());
            }
            if (property.getNamespaceURI().equals("http://s-ramp.org/xmlns/2010/s-ramp")) {
                String jcrPropName = null;
                jcrPropName = corePropertyMap.containsKey(property) ? corePropertyMap.get(property) : "sramp-properties:" + property.getLocalPart();
                this.builder.append("[");
                this.builder.append(jcrPropName);
                this.builder.append("]");
            } else {
                throw new RuntimeException("Properties from namespace '" + property.getNamespaceURI() + "' are not supported.");
            }
        }
        if (node.getSubartifactSet() != null) {
            throw new RuntimeException("Sub-artifact-set in a forward property step not yet supported.");
        }
    }

    public void visit(FunctionCall node) {
        throw new RuntimeException("Function calls not yet supported.");
    }

    public void visit(LocationPath node) {
        if (node.getArtifactType() != null) {
            this.appendCondition("[sramp:artifactType] = '" + node.getArtifactType().replace("'", "''") + "'");
        } else if (node.getArtifactModel() != null) {
            this.appendCondition("[sramp:artifactModel] = '" + node.getArtifactModel().replace("'", "''") + "'");
        } else {
            this.appendCondition("[sramp:artifactModel] LIKE '%'");
        }
    }

    public void visit(OrExpr node) {
        if (node.getRight() == null) {
            ((EqualityExpr)node.getLeft()).accept((XPathVisitor)this);
        } else {
            ((EqualityExpr)node.getLeft()).accept((XPathVisitor)this);
            this.builder.append(" OR ");
            ((OrExpr)node.getRight()).accept((XPathVisitor)this);
        }
    }

    public void visit(Predicate node) {
        node.getExpr().accept((XPathVisitor)this);
    }

    public void visit(PrimaryExpr node) {
        if (node.getLiteral() != null) {
            this.builder.append("'");
            this.builder.append(node.getLiteral());
            this.builder.append("'");
        } else if (node.getNumber() != null) {
            this.builder.append(node.getNumber());
        } else if (node.getPropertyQName() != null) {
            throw new RuntimeException("Property primary expressions not yet supported.");
        }
    }

    public void visit(Query node) {
        this.builder.append("SELECT * FROM [sramp:baseArtifactType]");
        node.getArtifactSet().accept((XPathVisitor)this);
        if (node.getPredicate() != null) {
            this.builder.append(" AND (");
            node.getPredicate().accept((XPathVisitor)this);
            this.builder.append(")");
        }
    }

    public void visit(RelationshipPath node) {
        throw new RuntimeException("Relationship paths not yet supported.");
    }

    public void visit(SubartifactSet node) {
        throw new RuntimeException("Sub-artifact-sets not yet supported.");
    }

    private void appendCondition(String condition) {
        this.builder.append(" WHERE ");
        this.builder.append(condition);
    }

    static {
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "createdBy"), "jcr:createdBy");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "version"), "version");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "uuid"), "sramp:uuid");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "createdTimestamp"), "jcr:created");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "lastModifiedTimestamp"), "jcr:lastModified");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "lastModifiedBy"), "jcr:lastModifiedBy");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "description"), "sramp:description");
        corePropertyMap.put(new QName("http://s-ramp.org/xmlns/2010/s-ramp", "name"), "sramp:name");
    }
}

