/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.repository.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.overlord.sramp.query.xpath.XPathParser;
import org.overlord.sramp.query.xpath.ast.Query;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.InvalidQueryException;
import org.overlord.sramp.repository.query.NumberReplacementParam;
import org.overlord.sramp.repository.query.QueryExecutionException;
import org.overlord.sramp.repository.query.QueryReplacementParam;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.repository.query.StringReplacementParam;

public abstract class AbstractSrampQueryImpl
implements SrampQuery {
    private static final XPathParser sParser = new XPathParser();
    private String xpathTemplate;
    private List<QueryReplacementParam<?>> replacementParams = new ArrayList();
    private String orderByProperty;
    private boolean orderAscending;

    public AbstractSrampQueryImpl(String xpathTemplate, String orderByProperty, boolean orderAscending) {
        this.setXpathTemplate(xpathTemplate);
        this.setOrderByProperty(orderByProperty);
        this.setOrderAscending(orderAscending);
    }

    protected String getXpathTemplate() {
        return this.xpathTemplate;
    }

    protected void setXpathTemplate(String xpathTemplate) {
        this.xpathTemplate = xpathTemplate;
    }

    protected String getOrderByProperty() {
        return this.orderByProperty;
    }

    protected void setOrderByProperty(String orderByProperty) {
        this.orderByProperty = orderByProperty;
    }

    protected boolean isOrderAscending() {
        return this.orderAscending;
    }

    protected void setOrderAscending(boolean orderAscending) {
        this.orderAscending = orderAscending;
    }

    @Override
    public void setString(String paramValue) {
        this.replacementParams.add(new StringReplacementParam(paramValue));
    }

    @Override
    public void setNumber(int paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(long paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(float paramValue) {
        this.replacementParams.add(new NumberReplacementParam(Float.valueOf(paramValue)));
    }

    @Override
    public void setNumber(double paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public void setNumber(BigInteger paramValue) {
        this.replacementParams.add(new NumberReplacementParam(paramValue));
    }

    @Override
    public final ArtifactSet executeQuery() throws InvalidQueryException, QueryExecutionException {
        String xpathTemplate = this.getXpathTemplate();
        String xpath = AbstractSrampQueryImpl.formatQuery(xpathTemplate, this.replacementParams);
        Query queryModel = AbstractSrampQueryImpl.parseXPath(xpath);
        this.validateQuery(queryModel);
        return this.executeQuery(queryModel);
    }

    protected static final String formatQuery(String xpathTemplate, List<QueryReplacementParam<?>> replacementParams) throws InvalidQueryException {
        StringBuilder builder = new StringBuilder();
        String[] xpathSegments = xpathTemplate.split("\\?");
        int paramCounter = 0;
        for (String segment : xpathSegments) {
            boolean isLastSegment;
            builder.append(segment);
            boolean bl = isLastSegment = segment == xpathSegments[xpathSegments.length - 1];
            if (isLastSegment) continue;
            if (paramCounter >= replacementParams.size()) {
                throw new InvalidQueryException("Not enough query replacement parameters provided.");
            }
            QueryReplacementParam<?> param = replacementParams.get(paramCounter);
            builder.append(param.getFormattedValue());
            ++paramCounter;
        }
        if (replacementParams.size() > paramCounter) {
            throw new InvalidQueryException("Too many query replacement parameters provided.");
        }
        return builder.toString();
    }

    protected static final Query parseXPath(String xpath) throws InvalidQueryException {
        try {
            return sParser.parseXPath(xpath);
        }
        catch (Exception e) {
            throw new InvalidQueryException("Query failed to parse.", e);
        }
    }

    protected void validateQuery(Query queryModel) throws InvalidQueryException {
    }

    protected abstract ArtifactSet executeQuery(Query var1) throws QueryExecutionException;
}

