/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.building;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.bonita.util.Misc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlBuilder {
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private Document document;
    private Node rootNode;

    public XmlBuilder(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
        try {
            this.transformerFactory.setAttribute("indent-number", 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] done() throws Exception {
        this.document.appendChild(this.rootNode);
        DOMSource source = new DOMSource(this.document);
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] xmlContent = null;
        try {
            StreamResult resultat = new StreamResult(new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
            transformer.transform(source, resultat);
            xmlContent = outputStream.toByteArray();
        }
        finally {
            outputStream.close();
        }
        return xmlContent;
    }

    public XmlBuilder createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        return this;
    }

    public Node createRootNode(String name) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(null, name, null, null);
    }

    public Node createRootNode(String name, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(null, name, null, attributes);
    }

    public Node createRootNode(String name, Serializable value) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(null, name, value, null);
        }
        return null;
    }

    public Node createRootNode(String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(null, name, value, attributes);
        }
        return null;
    }

    public Node createNode(Node parentNode, String name) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(parentNode, name, null, null);
    }

    public Node createNode(Node parentNode, String name, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        return this.internalNodeCreation(parentNode, name, null, attributes);
    }

    public Node createNode(Node parentNode, String name, Serializable value) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(parentNode, name, value, null);
        }
        return null;
    }

    public Node createNode(Node parentNode, String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        if (value != null) {
            return this.internalNodeCreation(parentNode, name, value, attributes);
        }
        return null;
    }

    public Node internalNodeCreation(Node parentNode, String name, Serializable value, Map<String, Serializable> attributes) throws DOMException, IOException, ClassNotFoundException {
        Element element = this.document.createElement(name);
        if (value != null) {
            if (value.getClass().isEnum()) {
                element.setTextContent(((Enum)((Object)value)).name());
            } else if (value instanceof byte[]) {
                element.setTextContent(Misc.fragmentAndBase64Encode((byte[])value));
            } else if (value instanceof Date) {
                element.setTextContent(Long.toString(((Date)value).getTime()));
            } else {
                element.setTextContent(value.toString());
            }
        }
        if (attributes != null) {
            for (Map.Entry<String, Serializable> attribute : attributes.entrySet()) {
                String attributeName = attribute.getKey();
                Serializable attributeValue = attribute.getValue();
                if (attributeValue.getClass().isEnum()) {
                    element.setAttribute(attributeName, ((Enum)((Object)attributeValue)).name());
                    continue;
                }
                if (attributeValue instanceof byte[]) {
                    element.setAttribute(attributeName, Misc.fragmentAndBase64Encode((byte[])attributeValue));
                    continue;
                }
                if (attributeValue instanceof Date) {
                    element.setAttribute(attributeName, Long.toString(((Date)attributeValue).getTime()));
                    continue;
                }
                element.setAttribute(attributeName, attributeValue.toString());
            }
        }
        if (parentNode == null) {
            this.rootNode = element;
            return element;
        }
        return parentNode.appendChild(element);
    }
}

