/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConditionEvaluator;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.BoundaryEvent;
import org.ow2.bonita.facade.def.element.EventDefinition;
import org.ow2.bonita.facade.def.element.impl.ErrorBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.element.impl.MessageBoundaryEventImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.EventProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;

public class ActivityUtil {
    static void deleteEvents(String eventName, String processName, String activityName, ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        for (IncomingEventInstance incoming : eventService.getIncomingEvents(eventName, processName, activityName, activityUUID)) {
            eventService.removeEvent(incoming);
        }
        for (OutgoingEventInstance outgoing : eventService.getOutgoingEvents(eventName, processName, activityName, activityUUID)) {
            eventService.removeEvent(outgoing);
        }
    }

    static void deleteBoundaryEvents(ActivityInstanceUUID activityUUID) {
        EventService eventService = EnvTool.getEventService();
        for (IncomingEventInstance incoming : eventService.getBoundaryIncomingEvents(activityUUID)) {
            eventService.removeEvent(incoming);
        }
        for (OutgoingEventInstance outgoing : eventService.getBoundaryOutgoingEvents(activityUUID)) {
            eventService.removeEvent(outgoing);
        }
    }

    static boolean evaluateTransition(TransitionDefinition t, Execution internalExecution) {
        String condition = t.getCondition();
        boolean conditionOK = true;
        if (condition != null && !(conditionOK = ConditionEvaluator.evaluate(condition, internalExecution)) && AbstractActivity.LOG.isLoggable(Level.FINE)) {
            AbstractActivity.LOG.fine("Unable to take transition: " + t.getName());
        }
        return conditionOK;
    }

    static boolean evaluateLoopCondition(ActivityDefinition activity, Execution internalExecution) {
        boolean execute = true;
        if (activity.isInALoop()) {
            String condition = activity.getLoopCondition();
            execute = ConditionEvaluator.evaluate(condition, internalExecution);
        }
        return execute;
    }

    static boolean isJoinOk(InternalProcessInstance instance, ActivityDefinition node) {
        if (!node.hasIncomingTransitions()) {
            return true;
        }
        if (node.getJoinType().equals((Object)ActivityDefinition.JoinType.XOR)) {
            for (TransitionDefinition transition : node.getIncomingTransitions()) {
                InternalProcessInstance.TransitionState ts = instance.getTransitionState(transition.getName());
                if (ts == null || !ts.equals((Object)InternalProcessInstance.TransitionState.TAKEN)) continue;
                return true;
            }
            return false;
        }
        for (TransitionDefinition transition : node.getIncomingTransitions()) {
            InternalProcessInstance.TransitionState ts = instance.getTransitionState(transition.getName());
            if (ts != null && ts.equals((Object)InternalProcessInstance.TransitionState.TAKEN)) continue;
            return false;
        }
        return true;
    }

    static void createNewIteration(Execution execution, ActivityDefinition activity) {
        if (activity.isInCycle()) {
            InternalProcessInstance instance = execution.getInstance();
            InternalProcessDefinition process = EnvTool.getJournalQueriers().getProcess(instance.getProcessDefinitionUUID());
            Set<IterationDescriptor> iterationDescriptors = process.getIterationDescriptors();
            boolean newCycle = ActivityUtil.isAtTheBeginningOfACycle(execution, activity, iterationDescriptors);
            if (newCycle) {
                String iterationUUID = Misc.getUniqueId("it");
                execution.setIterationId(iterationUUID);
                for (IterationDescriptor it : iterationDescriptors) {
                    if (!it.getEntryNodes().contains(execution.getNode().getName())) continue;
                    for (String joinNodeDescr : it.getCycleNodes()) {
                        ActivityDefinition joinNode = process.getActivity(joinNodeDescr);
                        for (TransitionDefinition tr : joinNode.getIncomingTransitions()) {
                            if (!it.containsNode(tr.getFrom())) continue;
                            instance.removeTransitionState(tr.getName());
                        }
                        if (!ActivityUtil.isJoinOk(instance, joinNode)) continue;
                        String message = ExceptionManager.getInstance().getFullMessage("be_AA_7", joinNode.getName());
                        throw new BonitaRuntimeException(message);
                    }
                }
            }
        }
    }

    static boolean isAtTheBeginningOfACycle(Execution execution, ActivityDefinition activity, Set<IterationDescriptor> iterationDescriptors) {
        boolean newCycleIteration = false;
        if (activity.isInCycle()) {
            Iterator<IterationDescriptor> iterator = iterationDescriptors.iterator();
            while (!newCycleIteration && iterator.hasNext()) {
                IterationDescriptor iteration = iterator.next();
                if (!iteration.getEntryNodes().contains(execution.getNode().getName())) continue;
                newCycleIteration = true;
            }
        }
        return newCycleIteration;
    }

    static String getErrorEventName(ActivityDefinition activity, String errorCode) {
        List<ErrorBoundaryEventImpl> events = ActivityUtil.getErrorEvents(activity.getBoundaryEvents());
        String errorName = null;
        String errorAllName = null;
        for (int i = 0; errorName == null && i < events.size(); ++i) {
            ErrorBoundaryEventImpl event = events.get(i);
            String eventErrorCode = event.getErrorCode();
            if (eventErrorCode == null) {
                errorAllName = event.getName();
                continue;
            }
            if (!errorCode.equals(eventErrorCode)) continue;
            errorName = event.getName();
        }
        String errorEventName = null;
        if (errorName != null) {
            errorEventName = errorName + "@3^3NT5@" + errorCode;
        } else if (errorAllName != null) {
            errorEventName = errorAllName + "@3^3NT5@" + "all";
        } else if (errorCode.equals(activity.getTimerCondition())) {
            errorEventName = activity.getName() + "@3^3NT5@" + errorCode;
        }
        return errorEventName;
    }

    public static ActivityDefinition getMatchingErrorEvenSubProcessActivity(Execution execution, String throwingErrorCode) {
        InternalProcessDefinition process = execution.getProcessDefinition();
        List<EventProcessDefinition> eventSubProcesses = process.getEventSubProcesses();
        if (!eventSubProcesses.isEmpty()) {
            for (EventProcessDefinition eventSubProcess : eventSubProcesses) {
                InternalProcessDefinition eventSubProcessDefinition = EnvTool.getJournalQueriers().getProcess(eventSubProcess.getName(), eventSubProcess.getVersion());
                Set<ActivityDefinition> eventSubActivities = eventSubProcessDefinition.getActivities();
                for (ActivityDefinition activityDefinition : eventSubActivities) {
                    if (activityDefinition.getIncomingTransitions().size() != 0 || !activityDefinition.isCatchingErrorEvent() || !activityDefinition.getTimerCondition().equals(throwingErrorCode)) continue;
                    return activityDefinition;
                }
            }
        }
        return null;
    }

    private static List<ErrorBoundaryEventImpl> getErrorEvents(List<BoundaryEvent> events) {
        ArrayList<ErrorBoundaryEventImpl> errorEvents = new ArrayList<ErrorBoundaryEventImpl>();
        for (BoundaryEvent event : events) {
            if (!(event instanceof ErrorBoundaryEventImpl)) continue;
            errorEvents.add((ErrorBoundaryEventImpl)event);
        }
        return errorEvents;
    }

    static Job getErrorEventSubProcessJob(Execution execution, String errorCode) {
        InternalProcessDefinition process = execution.getProcessDefinition();
        ActivityDefinition eventSubProcessActivity = ActivityUtil.getMatchingErrorEvenSubProcessActivity(process, errorCode);
        if (eventSubProcessActivity != null) {
            Job startError = JobBuilder.startErrorJob(eventSubProcessActivity.getName(), eventSubProcessActivity.getUUID());
            startError.setEventSubProcessRootInstanceUUID(execution.getInstance().getUUID());
            return startError;
        }
        return null;
    }

    public static ActivityDefinition getMatchingErrorEvenSubProcessActivity(ProcessDefinition process, String throwingErrorCode) {
        List<EventProcessDefinition> eventSubProcesses = process.getEventSubProcesses();
        if (!eventSubProcesses.isEmpty()) {
            for (EventProcessDefinition eventSubProcess : eventSubProcesses) {
                InternalProcessDefinition eventSubProcessDefinition = EnvTool.getJournalQueriers().getProcess(eventSubProcess.getName(), eventSubProcess.getVersion());
                Set<ActivityDefinition> eventSubActivities = eventSubProcessDefinition.getActivities();
                for (ActivityDefinition activityDefinition : eventSubActivities) {
                    if (activityDefinition.getIncomingTransitions().size() != 0 || !activityDefinition.isCatchingErrorEvent() || !activityDefinition.getTimerCondition().equals(throwingErrorCode)) continue;
                    return activityDefinition;
                }
            }
        }
        return null;
    }

    static Job getTargetErrorJob(Execution execution) {
        Execution exec;
        String eventName;
        InternalProcessDefinition process = execution.getProcessDefinition();
        InternalProcessInstance instance = execution.getInstance();
        ActivityInstanceUUID parentActivityUUID = null;
        if (LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS.equals((Object)process.getType())) {
            InternalProcessInstance rootEventSubProcess = EnvTool.getJournalQueriers().getProcessInstance(instance.getParentInstanceUUID());
            parentActivityUUID = rootEventSubProcess.getParentActivityUUID();
        } else {
            parentActivityUUID = instance.getParentActivityUUID();
        }
        if (parentActivityUUID != null && (eventName = ActivityUtil.getErrorEventName((exec = EnvTool.getJournalQueriers().getExecutionOnActivity(parentActivityUUID.getProcessInstanceUUID(), parentActivityUUID)).getNode(), execution.getNode().getTimerCondition())) != null) {
            int indexOf = eventName.indexOf("@3^3NT5@");
            return JobBuilder.boundaryErrorJob(eventName.substring(0, indexOf), exec.getInstance().getRootInstanceUUID(), exec.getEventUUID(), exec.getInstance().getProcessInstanceUUID());
        }
        return null;
    }

    public static void deleteJobs(String executionEventUUID) {
        if (executionEventUUID != null) {
            EventService eventService = EnvTool.getEventService();
            eventService.removeJobs(executionEventUUID);
        }
    }

    public static String getEvaluatedCorrelationKey(ActivityInstanceUUID activityUUID, String correlationKeyName, String correlationKeyExpression) {
        if (correlationKeyExpression != null) {
            try {
                String expression = GroovyUtil.evaluate(correlationKeyExpression, null, activityUUID, false, false).toString();
                return correlationKeyName.concat("||||").concat(expression);
            }
            catch (GroovyException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return null;
    }

    public static void addCorrelationKeys(EventDefinition eventDefinition, EventInstance eventInstance, ActivityInstanceUUID activityUUID) {
        String correlationKey;
        String correlationKeyName = eventDefinition.getCorrelationKeyName1();
        if (correlationKeyName != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression1());
            eventInstance.setCorrelationKey1(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName2()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression2());
            eventInstance.setCorrelationKey2(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName3()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression3());
            eventInstance.setCorrelationKey3(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName4()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression4());
            eventInstance.setCorrelationKey4(correlationKey);
        }
        if ((correlationKeyName = eventDefinition.getCorrelationKeyName5()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, eventDefinition.getCorrelationKeyExpression5());
            eventInstance.setCorrelationKey5(correlationKey);
        }
    }

    public static void addCorrelationKeys(MessageBoundaryEventImpl message, IncomingEventInstance eventInstance, ActivityInstanceUUID activityUUID) {
        String correlationKey;
        String correlationKeyName = message.getCorrelationKeyName1();
        if (correlationKeyName != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, message.getCorrelationKeyExpression1());
            eventInstance.setCorrelationKey1(correlationKey);
        }
        if ((correlationKeyName = message.getCorrelationKeyName2()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, message.getCorrelationKeyExpression2());
            eventInstance.setCorrelationKey2(correlationKey);
        }
        if ((correlationKeyName = message.getCorrelationKeyName3()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, message.getCorrelationKeyExpression3());
            eventInstance.setCorrelationKey3(correlationKey);
        }
        if ((correlationKeyName = message.getCorrelationKeyName4()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, message.getCorrelationKeyExpression4());
            eventInstance.setCorrelationKey4(correlationKey);
        }
        if ((correlationKeyName = message.getCorrelationKeyName5()) != null) {
            correlationKey = ActivityUtil.getEvaluatedCorrelationKey(activityUUID, correlationKeyName, message.getCorrelationKeyExpression5());
            eventInstance.setCorrelationKey5(correlationKey);
        }
    }
}

