/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.deployment.BARVersion;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.deployment.IterationDetection;
import org.ow2.bonita.deployment.IterationDetectionNoException;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BoundaryEvent;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.EventDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.impl.CategoryImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.iteration.IterationNode;
import org.ow2.bonita.iteration.IterationProcess;
import org.ow2.bonita.iteration.IterationTransition;
import org.ow2.bonita.iteration.SuspiciousIterationException;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.runtime.IterationDetectionPolicy;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.ArchiveTool;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;

public final class Deployer {
    private static final Logger LOG = Logger.getLogger(Deployer.class.getName());

    private Deployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition deploy(BusinessArchive businessArchive) throws DeploymentException {
        Recorder recorder = EnvTool.getRecorder();
        ProcessDefinitionUUID processUUID = businessArchive.getProcessUUID();
        if (processUUID == null) {
            throw new DeploymentException("The given businessArchive does not contain any process.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        for (Map.Entry<String, byte[]> resource : businessArchive.getResources().entrySet()) {
            ldr.storeData(Misc.getBusinessArchiveCategories(processUUID), resource.getKey(), (Serializable)resource.getValue(), true);
        }
        boolean removeDeps = true;
        IterationProcess iterationProcess = null;
        try {
            BARVersion barVersion;
            int versionComparison;
            Set<IterationDescriptor> iterationDescriptors;
            ClassLoader current;
            ProcessDefinition process;
            block33: {
                process = null;
                current = Thread.currentThread().getContextClassLoader();
                iterationDescriptors = null;
                try {
                    ClassLoader processClassloader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
                    Thread.currentThread().setContextClassLoader(processClassloader);
                    process = businessArchive.getProcessDefinition();
                    if (process == null) {
                        throw new DeploymentRuntimeException("The given bar archive does not contain any process file");
                    }
                    iterationProcess = Deployer.getIterationProcess(process);
                    iterationDescriptors = Deployer.getIterations(iterationProcess);
                }
                catch (SuspiciousIterationException sie) {
                    if (EnvTool.getIterationDetectionPolicy() == IterationDetectionPolicy.DISABLE) {
                        LOG.log(Level.WARNING, "The iteration detection is disable but a suspicious cycle was detected in process " + processUUID + ", disabling this is not recommanded, use this process at your own risks", sie);
                        iterationDescriptors = Deployer.getIterations(iterationProcess, false);
                        break block33;
                    }
                    throw sie;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
            for (IterationDescriptor iterationDescriptor : iterationDescriptors) {
                ((ProcessDefinitionImpl)process).addIterationDescriptors(iterationDescriptor);
                for (String activityName : iterationDescriptor.getCycleNodes()) {
                    ActivityDefinitionImpl activity = (ActivityDefinitionImpl)process.getActivity(activityName);
                    activity.setInCycle(true);
                }
            }
            String lastProcessVersion = EnvTool.getAllQueriers().getLastProcessVersion(process.getName());
            if (lastProcessVersion != null && (versionComparison = (barVersion = new BARVersion(process.getVersion())).compareTo(lastProcessVersion)) <= 0) {
                if (versionComparison == 0) {
                    removeDeps = false;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bd_D_3", process.getName(), lastProcessVersion, process.getVersion(), lastProcessVersion);
                throw new DeploymentRuntimeException(message);
            }
            if (process.getClassDependencies() != null) {
                for (String className : process.getClassDependencies()) {
                    try {
                        EnvTool.getClassDataLoader().getClass(process.getUUID(), className);
                    }
                    catch (ClassNotFoundException e) {
                        String message = ExceptionManager.getInstance().getFullMessage("bd_D_7", process.getName(), className);
                        throw new DeploymentRuntimeException(message);
                    }
                }
            }
            DocumentationManager manager = EnvTool.getDocumentationManager();
            for (AttachmentDefinition attachment : process.getAttachments().values()) {
                if (attachment.getFilePath() != null) {
                    byte[] content = businessArchive.getResource(attachment.getFilePath());
                    try {
                        manager.createDocument(attachment.getName(), attachment.getProcessDefinitionUUID(), attachment.getFileName(), "application/octet-stream", content);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException(e);
                    }
                }
                try {
                    manager.createDocument(attachment.getName(), attachment.getProcessDefinitionUUID());
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e);
                }
            }
            InternalProcessDefinition internalProcess = null;
            try {
                Thread.currentThread().setContextClassLoader(EnvTool.getClassDataLoader().getProcessClassLoader(processUUID));
                internalProcess = new InternalProcessDefinition(process);
                if (internalProcess.getCategoryNames() != null && !internalProcess.getCategoryNames().isEmpty()) {
                    ArrayList<String> categoryNamesToBind = new ArrayList<String>(internalProcess.getCategoryNames());
                    Set<Category> persistedCategories = EnvTool.getJournalQueriers().getCategories(categoryNamesToBind);
                    if (persistedCategories.size() < categoryNamesToBind.size()) {
                        for (Category category : persistedCategories) {
                            categoryNamesToBind.remove(category.getName());
                        }
                        for (String name : categoryNamesToBind) {
                            recorder.recordNewCategory(new CategoryImpl(name));
                        }
                    }
                }
                internalProcess.setNbOfAttachments(process.getAttachments().size());
                recorder.recordProcessDeployed(internalProcess, EnvTool.getUserId());
                Deployer.addStartEvents(internalProcess);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            return new ProcessDefinitionImpl(internalProcess);
        }
        catch (RuntimeException re) {
            EnvTool.getClassDataLoader().removeProcessClassLoader(processUUID);
            if (removeDeps) {
                ldr.deleteData(Misc.getBusinessArchiveCategories(processUUID));
                ldr.deleteData(Misc.getAttachmentCategories(processUUID));
            }
            throw re;
        }
    }

    public static IterationProcess getIterationProcess(ProcessDefinition process) {
        IterationProcess iterationProcess = new IterationProcess();
        for (ActivityDefinition activityDefinition : process.getActivities()) {
            String joinType = activityDefinition.getJoinType().toString();
            String splitType = activityDefinition.getSplitType().toString();
            IterationNode node = new IterationNode(activityDefinition.getName(), IterationNode.JoinType.valueOf(joinType), IterationNode.SplitType.valueOf(splitType));
            iterationProcess.addNode(node);
        }
        for (ActivityDefinition activityDefinition : process.getActivities()) {
            IterationNode destination;
            IterationNode node = iterationProcess.getNode(activityDefinition.getName());
            for (TransitionDefinition transition : activityDefinition.getIncomingTransitions()) {
                IterationNode source = iterationProcess.getNode(transition.getFrom());
                node.addIncomingTransition(new IterationTransition(source, node));
            }
            for (TransitionDefinition transition : activityDefinition.getOutgoingTransitions()) {
                destination = iterationProcess.getNode(transition.getTo());
                node.addOutgoingTransition(new IterationTransition(node, destination));
            }
            for (BoundaryEvent boundaryEvent : activityDefinition.getBoundaryEvents()) {
                destination = iterationProcess.getNode(boundaryEvent.getTransition().getTo());
                node.addOutgoingTransition(new IterationTransition(node, destination));
            }
        }
        return iterationProcess;
    }

    public static Set<IterationDescriptor> getIterations(IterationProcess process) {
        return IterationDetection.findIterations(process);
    }

    public static Set<IterationDescriptor> getIterations(IterationProcess process, boolean throwException) {
        return IterationDetectionNoException.findIterations(process);
    }

    public static boolean enableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to enable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to enable a process which is state is not disable");
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessEnable(processDef);
        Deployer.addStartEvents(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" enable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean disableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to disable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.ENABLED)) {
            throw new DeploymentRuntimeException("Impossible to disable a process which is state is not enable");
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessDisable(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" disable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean archiveProcess(ProcessDefinitionUUID processUUID, String userId) {
        Misc.badStateIfNull(processUUID, "Impossible to archive a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to archive a process which its state is not disable");
        }
        HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
        definitionUUIDs.add(processUUID);
        int numberOfProcessInstances = journal.getNumberOfProcessInstances(definitionUUIDs);
        if (numberOfProcessInstances != 0) {
            throw new DeploymentRuntimeException("Impossible to archive a process with " + numberOfProcessInstances + " running instance(s)");
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessArchive(processDef, userId);
        ArchiveTool.atomicArchive(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" archive (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        EnvTool.getClassDataLoader().removeProcessClassLoader(processDef.getUUID());
        EnvTool.getUUIDService().archiveOrDeleteProcess(processUUID);
        return true;
    }

    private static void addStartEvents(ProcessDefinition processDef) throws DeploymentRuntimeException {
        EventService eventService = EnvTool.getEventService();
        eventService.lockProcessDefinition(processDef.getUUID());
        if (LightProcessDefinition.ProcessType.PROCESS.equals((Object)processDef.getType())) {
            for (ActivityDefinition activity : processDef.getActivities()) {
                if (!activity.getIncomingTransitions().isEmpty()) continue;
                ActivityDefinition.Type activityType = activity.getType();
                if (activityType.equals((Object)ActivityDefinition.Type.ReceiveEvent)) {
                    IncomingEventDefinition event = activity.getIncomingEvent();
                    if (event == null) continue;
                    IncomingEventInstance eventInstance = new IncomingEventInstance(event.getName(), event.getExpression(), null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, "start", System.currentTimeMillis(), false);
                    eventInstance.setPermanent(true);
                    ProcessUtil.addCorrelationKeys((EventDefinition)event, (EventInstance)eventInstance, processDef.getUUID());
                    eventService.subscribe(eventInstance);
                    continue;
                }
                if (activityType.equals((Object)ActivityDefinition.Type.Timer)) {
                    ProcessDefinitionUUID definitionUUID = activity.getProcessDefinitionUUID();
                    String condition = activity.getTimerCondition();
                    try {
                        Date date = ProcessUtil.getTimerDate(condition, definitionUUID, System.currentTimeMillis());
                        Job timer = JobBuilder.startTimerJob(activity.getName(), activity.getUUID(), condition, date.getTime());
                        eventService.storeJob(timer);
                        continue;
                    }
                    catch (GroovyException e) {
                        throw new DeploymentRuntimeException(e.getMessage(), e.getCause());
                    }
                }
                if (!activityType.equals((Object)ActivityDefinition.Type.SignalEvent)) continue;
                String eventName = activity.getTimerCondition();
                IncomingEventInstance signalEventInstance = new IncomingEventInstance(eventName, null, null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, "event.start.signal", -1L, false);
                signalEventInstance.setPermanent(true);
                eventService.subscribe(signalEventInstance);
            }
        }
    }

    public static void removeStartEvents(ProcessDefinition processDef) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeLock(processDef.getUUID());
        for (ActivityDefinition activity : processDef.getActivities()) {
            if (!activity.getIncomingTransitions().isEmpty()) continue;
            ActivityDefinition.Type activityType = activity.getType();
            IncomingEventDefinition event = activity.getIncomingEvent();
            if (event != null || activityType.equals((Object)ActivityDefinition.Type.SignalEvent)) {
                eventService.removeSubscriptions(activity.getUUID());
                eventService.removeJob(activity.getUUID());
                continue;
            }
            if (!activityType.equals((Object)ActivityDefinition.Type.Timer) && !activityType.equals((Object)ActivityDefinition.Type.ErrorEvent)) continue;
            eventService.removeJob(activity.getUUID());
        }
    }
}

