/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.BonitaEnvironmentParser;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.InvalidEnvironmentException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ServerConstants;

public final class GlobalEnvironmentFactory {
    private static final Logger LOG = Logger.getLogger(GlobalEnvironmentFactory.class.getName());
    private static Map<String, EnvironmentFactory> environmentFactories = new HashMap<String, EnvironmentFactory>();
    private static final Object LOCK = new Object();

    private GlobalEnvironmentFactory() {
    }

    private static String getEnvironmentResource(String domain) throws Exception {
        if (domain == null || domain.length() == 0) {
            throw new InvalidEnvironmentException("Unknown domain: '" + domain + "'");
        }
        String confPath = ServerConstants.getTenantConfigurationFolder(domain);
        StringBuilder serverConfigurationPath = new StringBuilder(confPath);
        serverConfigurationPath.append(File.separator).append("bonita-server.xml");
        String envPath = serverConfigurationPath.toString();
        File environmentPropertiesFile = new File(envPath);
        if (!environmentPropertiesFile.exists()) {
            throw new FileNotFoundException(envPath);
        }
        return envPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvironmentFactory getEnvironmentFactory(String domain) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            if (environmentFactories.get(domain) == null) {
                byte[] content;
                String environmentResource = GlobalEnvironmentFactory.getEnvironmentResource(domain);
                URL url = null;
                File file = new File(environmentResource);
                if (file.exists()) {
                    try {
                        url = file.toURI().toURL();
                    }
                    catch (MalformedURLException e1) {
                        Misc.unreachableStatement();
                    }
                }
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("Reading environment configuration from: " + url);
                }
                try {
                    content = Misc.getAllContentFrom(url);
                }
                catch (IOException e) {
                    String message = ExceptionManager.getInstance().getFullMessage("benv_GEF_1", url);
                    throw new InvalidEnvironmentException(message, e);
                }
                String environment = new String(content);
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("The environment resource " + url + " contains: " + Misc.LINE_SEPARATOR + environment);
                }
                EnvironmentFactory factory = BonitaEnvironmentParser.parseEnvironmentFactoryFromXmlString(environment);
                GlobalEnvironmentFactory.setEnvironmentFactory(domain, factory);
                Runtime.getRuntime().addShutdownHook(new BonitaShutdownHook());
            }
            if (environmentFactories.get(domain) == null) {
                String message = ExceptionManager.getInstance().getFullMessage("benv_GEF_2", new Object[0]);
                throw new InvalidEnvironmentException(message);
            }
            return environmentFactories.get(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnvironmentFactory(String domain, EnvironmentFactory envFactory) {
        Object object = LOCK;
        synchronized (object) {
            environmentFactories.put(domain, envFactory);
        }
    }

    public static boolean isInitialized(String domain) {
        return environmentFactories.get(domain) != null;
    }

    static class BonitaShutdownHook
    extends Thread {
        @Override
        public void run() {
            try {
                if (environmentFactories != null) {
                    for (EnvironmentFactory environmentFactory : environmentFactories.values()) {
                        if (environmentFactory == null) continue;
                        environmentFactory.close();
                    }
                    environmentFactories.clear();
                }
            }
            catch (Exception ee) {
                LOG.severe(Misc.getStackTraceFrom(ee));
            }
        }
    }
}

