/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.GlobalEnvironmentFactory;
import org.ow2.bonita.env.InvalidEnvironmentException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.monitoring.model.Jvm;
import org.ow2.bonita.facade.monitoring.model.JvmMBean;
import org.ow2.bonita.facade.monitoring.model.MBeanStartException;
import org.ow2.bonita.facade.monitoring.model.MBeanStopException;
import org.ow2.bonita.identity.auth.APIMethodsSecurity;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;

public class APIInterceptor
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = Logger.getLogger(APIInterceptor.class.getName());
    private final Object api;
    private static JvmMBean jvmMBean;
    private static Object lockObj;

    public APIInterceptor(Object api) {
        this.api = api;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws BonitaException {
        BonitaConstants.getBonitaHomeFolder();
        try {
            if (Environment.getCurrent() != null) {
                return new APIInterceptorCommand(method, args, true).execute(Environment.getCurrent());
            }
            EnvironmentFactory envFactory = GlobalEnvironmentFactory.getEnvironmentFactory(DomainOwner.getDomain());
            return envFactory.get(CommandService.class).execute(new APIInterceptorCommand(method, args, false));
        }
        catch (BonitaRuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BonitaException) {
                throw (BonitaException)cause;
            }
            if (e instanceof InvalidEnvironmentException) {
                throw e;
            }
            if (e instanceof BonitaWrapperException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        catch (BonitaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw BonitaInternalException.build(e);
        }
        catch (Exception t) {
            String message = ExceptionManager.getInstance().getFullMessage("bai_APII_2", t);
            throw new BonitaInternalException(message, t);
        }
    }

    static {
        lockObj = "this is a lock";
    }

    class APIInterceptorCommand
    implements Command<Object> {
        private static final long serialVersionUID = 6293853276365124717L;
        private final transient Method m;
        private final Object[] args;
        private final boolean isSecuritySet;

        public APIInterceptorCommand(Method m, Object[] args, boolean isSecuritySet) {
            this.args = args;
            this.m = m;
            this.isSecuritySet = isSecuritySet;
            if (LOG.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Creating APIInterceptorCommand: " + this + ". Method: " + m + ", isSecuritySet:" + isSecuritySet);
                if (args != null) {
                    for (Object arg : args) {
                        sb.append(" - Arg: " + arg);
                    }
                } else {
                    sb.append(" Args: null.");
                }
                LOG.fine(sb.toString());
            }
        }

        @Override
        public Object execute(Environment env) throws Exception {
            EnvTool.getEventExecutor();
            this.ensureMBeanIsRegistered();
            if (!this.isSecuritySet && APIMethodsSecurity.isSecuredMethod(this.m)) {
                String userId = null;
                try {
                    userId = EnvTool.getBonitaSecurityContext().getUser();
                }
                catch (Throwable t) {
                    userId = UserOwner.getUser();
                }
                Authentication.setUserId(userId);
            }
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Executing APIInterceptorCommand: " + this + " on api: " + APIInterceptor.this.api + ". Env: " + env);
                    LOG.fine(sb.toString());
                }
                return this.m.invoke(APIInterceptor.this.api, this.args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bai_APII_1", t);
                throw new BonitaInternalException(message, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureMBeanIsRegistered() {
            Object object = lockObj;
            synchronized (object) {
                if (jvmMBean != null) {
                    return;
                }
                try {
                    jvmMBean = new Jvm();
                    jvmMBean.start();
                    this.registerShutdownHookToRemoveMBean(jvmMBean);
                }
                catch (MalformedObjectNameException e) {
                    LOG.warning("jvmMBean can not been started:" + e.getMessage());
                }
                catch (NullPointerException e) {
                    LOG.warning("jvmMBean can not been started:" + e.getMessage());
                    e.printStackTrace();
                }
                catch (MBeanStartException e) {
                    LOG.warning("jvmMBean can not been started:" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        private void registerShutdownHookToRemoveMBean(final JvmMBean jvmMBean) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    block4: {
                        super.run();
                        try {
                            if (LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "Unregistering MBean as the JVM is going to shutdown...");
                            }
                            jvmMBean.stop();
                            if (LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "MBean unregistered.");
                            }
                        }
                        catch (MBeanStopException e) {
                            if (!LOG.isLoggable(Level.WARNING)) break block4;
                            LOG.log(Level.WARNING, "Unable to unregister MBean.", e);
                        }
                    }
                }
            });
        }
    }
}

