/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import java.util.Set;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class IllegalTaskStateException
extends BonitaException {
    private static final long serialVersionUID = 8686470271658322546L;
    private final ActivityInstanceUUID taskUUID;
    private final Set<ActivityState> expectedStates;
    private final ActivityState currentState;

    public IllegalTaskStateException(String id, String msg, ActivityInstanceUUID taskUUID, Set<ActivityState> expectedStates, ActivityState currentState) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("ITSE1", new Object[]{msg, taskUUID, expectedStates, currentState}));
        this.taskUUID = taskUUID;
        this.expectedStates = expectedStates;
        this.currentState = currentState;
    }

    public IllegalTaskStateException(IllegalTaskStateException e) {
        super(e.getMessage());
        this.taskUUID = e.getActivityInstanceUUID();
        this.expectedStates = e.getExpectedStates();
        this.currentState = e.getCurrentState();
    }

    public static IllegalTaskStateException build(String id, Throwable e) {
        if (!(e instanceof IllegalTaskStateException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("ITSE2", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new IllegalTaskStateException((IllegalTaskStateException)e);
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.taskUUID;
    }

    public Set<ActivityState> getExpectedStates() {
        return this.expectedStates;
    }

    public ActivityState getCurrentState() {
        return this.currentState;
    }
}

