/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class UnAuthorizedUserException
extends BonitaException {
    private static final long serialVersionUID = 1043694645994801762L;
    private String instanceUUID;
    private ActivityInstanceUUID taskUUID;
    private String userId;

    public UnAuthorizedUserException(String id, String msg, String instanceUUID, String userId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("UAUE1", userId, msg, instanceUUID));
        this.instanceUUID = instanceUUID;
        this.userId = userId;
        this.taskUUID = null;
    }

    public UnAuthorizedUserException(String id, String msg, String instanceUUID, ActivityInstanceUUID taskUUID, String userId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("UAUE2", userId, msg, taskUUID, instanceUUID));
        this.instanceUUID = instanceUUID;
        this.taskUUID = taskUUID;
        this.userId = userId;
    }

    public UnAuthorizedUserException(UnAuthorizedUserException e) {
        super(e.getMessage());
        this.instanceUUID = e.getInstanceUUID();
        this.taskUUID = e.getActivityInstanceUUID();
        this.userId = e.getUserId();
    }

    public UnAuthorizedUserException(String id, String msg, ActivityInstanceUUID taskUUID, String userId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("UAUE3", userId, msg, taskUUID));
        this.taskUUID = taskUUID;
        this.userId = userId;
    }

    public static UnAuthorizedUserException build(String id, Throwable e) {
        if (!(e instanceof UnAuthorizedUserException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("UAUE4", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new UnAuthorizedUserException((UnAuthorizedUserException)e);
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.taskUUID;
    }

    public String getInstanceUUID() {
        return this.instanceUUID;
    }

    public String getUserId() {
        return this.userId;
    }
}

