/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.identity.impl;

import java.util.UUID;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.util.Misc;

public class GroupImpl
extends DescriptionElementImpl
implements Group {
    private static final long serialVersionUID = -3862582387188894368L;
    protected long dbid;
    protected String uuid;
    protected String name;
    protected String label;
    protected Group parentGroup;

    protected GroupImpl() {
    }

    public GroupImpl(String name) {
        Misc.checkArgsNotNull(name);
        this.name = name;
        this.uuid = UUID.randomUUID().toString();
    }

    public GroupImpl(String uuid, String name) {
        Misc.checkArgsNotNull(uuid, name);
        this.uuid = uuid;
        this.name = name;
    }

    public GroupImpl(GroupImpl src) {
        super(src);
        this.uuid = src.getUUID();
        this.name = src.getName();
        this.label = src.getLabel();
        if (src.getParentGroup() != null) {
            this.parentGroup = new GroupImpl((GroupImpl)src.getParentGroup());
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public Group getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(Group parentGroup) {
        this.parentGroup = parentGroup;
    }
}

