/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.bonita.facade.BAMAPI;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.exception.MonitoringException;
import org.ow2.bonita.facade.monitoring.model.impl.MBeanUtil;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class BAMAPIImpl
implements BAMAPI {
    private final String queryList;

    protected BAMAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since) {
        Date now = new Date();
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfExecutingCasesPerDay(since, now);
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since) {
        Date now = new Date();
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfFinishedCasesPerDay(since, now);
    }

    @Override
    public int getNumberOfOpenSteps() {
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfOpenSteps();
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since) {
        Date now = new Date();
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfOpenStepsPerDay(since, now);
    }

    @Override
    public int getNumberOfOverdueSteps() {
        Date now = new Date();
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfOverdueSteps(now);
    }

    @Override
    public int getNumberOfStepsAtRisk(int remainingDays) {
        if (remainingDays < 0) {
            throw new IllegalArgumentException("The number of remaining days is negative");
        }
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfStepsAtRisk(currentDate, atRisk);
    }

    @Override
    public int getNumberOfUserOpenSteps() {
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfUserOpenSteps(userId);
    }

    @Override
    public int getNumberOfUserOverdueSteps() {
        Date now = new Date();
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfUserOverdueSteps(userId, now);
    }

    @Override
    public int getNumberOfUserStepsAtRisk(int remainingDays) {
        if (remainingDays < 0) {
            throw new IllegalArgumentException("The number of remaining days is negative");
        }
        String userId = EnvTool.getUserId();
        Date currentDate = new Date();
        Date beginningOfTheDay = DateUtil.getBeginningOfTheDay(currentDate);
        Date atRisk = DateUtil.backTo(beginningOfTheDay, -(remainingDays + 1));
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfUserStepsAtRisk(userId, currentDate, atRisk);
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since) {
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfFinishedSteps(priority, since);
    }

    @Override
    public int getNumberOfOpenSteps(int priority) {
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfOpenSteps(priority);
    }

    @Override
    public int getNumberOfUserFinishedSteps(int priority, Date since) {
        String userId = EnvTool.getUserId();
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfUserFinishedSteps(userId, priority, since);
    }

    @Override
    public int getNumberOfUserOpenSteps(int priority) {
        String userId = EnvTool.getUserId();
        return EnvTool.getJournalQueriers(this.getQueryList()).getNumberOfUserOpenSteps(userId, priority);
    }

    @Override
    public List<Long> getProcessInstancesDuration(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getHistoryQueriers(this.getQueryList()).getProcessInstancesDuration(since, until);
    }

    @Override
    public List<Long> getProcessInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getHistoryQueriers(this.getQueryList()).getProcessInstancesDuration(processUUID, since, until);
    }

    @Override
    public List<Long> getProcessInstancesDuration(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getHistoryQueriers(this.getQueryList()).getProcessInstancesDurationFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesExecutionTime(since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesExecutionTime(processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesExecutionTimeFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesExecutionTime(activityUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (activityUUIDs == null || activityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesExecutionTimeFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTime(since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ProcessDefinitionUUID processUUID, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTime(processUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ActivityDefinitionUUID taskUUID, Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTime(taskUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromTaskUUIDs(Set<ActivityDefinitionUUID> tasksUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(tasksUUIDs);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (tasksUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeFromTaskUUIDs(tasksUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, Date since, Date until) {
        Misc.checkArgsNotNull(username);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeOfUser(username, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(username, processUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeOfUser(username, processUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(String username, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(username, processUUIDs);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(username, processUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ActivityDefinitionUUID taskUUID, Date since, Date until) {
        Misc.checkArgsNotNull(username, taskUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeOfUser(username, taskUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(String username, Set<ActivityDefinitionUUID> tasksUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(username, tasksUUIDs);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (tasksUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(username, tasksUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDuration(since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(processUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDuration(processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(processUUIDs);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDurationFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        Misc.checkArgsNotNull(activityUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDuration(activityUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(activityUUIDs);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        if (activityUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDurationFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        Misc.checkArgsNotNull(new Object[]{activityType});
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDurationByActivityType(activityType, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(new Object[]{activityType, processUUID});
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDurationByActivityType(activityType, processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return Collections.emptyList();
        }
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getActivityInstancesDurationByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedProcessInstances(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedProcessInstances(since, until);
    }

    @Override
    public long getNumberOfCreatedProcessInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(processUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedProcessInstances(processUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(Date since, Date until) {
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstances(since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(processUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstances(processUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return 0L;
        }
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstancesFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ActivityDefinitionUUID activityUUID, Date since, Date until) {
        Misc.checkArgsNotNull(activityUUID);
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstances(activityUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until) {
        if (activityUUIDs == null || activityUUIDs.isEmpty()) {
            return 0L;
        }
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstancesFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, Date since, Date until) {
        Misc.checkArgsNotNull(new Object[]{activityType});
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstancesByActivityType(activityType, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until) {
        Misc.checkArgsNotNull(new Object[]{activityType, processUUID});
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstancesByActivityType(activityType, processUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until) {
        Misc.checkArgsNotNull(new Object[]{activityType});
        if (processUUIDs == null || processUUIDs.isEmpty()) {
            return 0L;
        }
        if (since.getTime() > until.getTime()) {
            throw new IllegalArgumentException("The since date is greater than the until date");
        }
        return EnvTool.getAllQueriers(this.getQueryList()).getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
    }

    @Override
    public long getCurrentMemoryUsage() throws MonitoringException {
        long result = 0L;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Long)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "CurrentMemoryUsage");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public float getMemoryUsagePercentage() throws MonitoringException {
        float result = 0.0f;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = ((Float)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "MemoryUsagePercentage")).floatValue();
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public double getSystemLoadAverage() throws MonitoringException {
        double result = 0.0;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Double)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "SystemLoadAverage");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public long getUpTime() throws MonitoringException {
        long result = 0L;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Long)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "UpTime");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public long getStartTime() throws MonitoringException {
        long result = 0L;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Long)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "StartTime");
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (NullPointerException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public long getTotalThreadsCpuTime() throws MonitoringException {
        long result = 0L;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Long)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "TotalThreadsCpuTime");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int getThreadCount() throws MonitoringException {
        int result = 0;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Integer)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "ThreadCount");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int getAvailableProcessors() throws MonitoringException {
        int result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (Integer)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "AvailableProcessors");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getOSArch() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "OSArch");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getOSName() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "OSName");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getOSVersion() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "OSVersion");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getJvmName() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "JvmName");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getJvmVendor() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "JvmVendor");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String getJvmVersion() throws MonitoringException {
        String result;
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            result = (String)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "JvmVersion");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public Map<String, String> getJvmSystemProperties() throws MonitoringException {
        MBeanServer mbeanServer = MBeanUtil.getMBeanServer();
        try {
            return (Map)mbeanServer.getAttribute(new ObjectName("Bonitasoft:name=JVM,type=JVMMBean"), "JvmSystemProperties");
        }
        catch (MalformedObjectNameException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (MBeanException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new MonitoringException(e.getMessage(), e);
        }
    }
}

