/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.ow2.bonita.facade.BAMAPI;
import org.ow2.bonita.facade.QueryAPIAccessor;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.internal.RESTRemoteQueryRuntimeAPI;
import org.ow2.bonita.facade.internal.RemoteBAMAPI;
import org.ow2.bonita.facade.internal.RemoteQueryDefinitionAPI;
import org.ow2.bonita.facade.rest.interceptor.BonitaClientErrorInterceptor;
import org.ow2.bonita.facade.rest.interceptor.RESTClientExecutionInterceptor;
import org.ow2.bonita.facade.rest.provider.GenericObjectProvider;
import org.ow2.bonita.facade.rest.provider.OctectStreamProvider;
import org.ow2.bonita.facade.rest.stringconverter.ActivityInstanceImplStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.ActivityInstanceStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.AttachementInstanceStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.BusinessArchiveStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.ConnectorExecutionDescriptorStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.DateStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.GenericObjectStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.HashMapStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.MapStringConverter;
import org.ow2.bonita.facade.rest.stringconverter.RuleStringConverter;
import org.ow2.bonita.util.AccessorProxyUtil;

public class RESTQueryAPIAccessorImpl
implements QueryAPIAccessor {
    private static final Logger LOG = Logger.getLogger(RESTQueryAPIAccessorImpl.class.getName());
    private static ResteasyProviderFactory providerFactory;
    private static final ClientExecutor clientExecutor;
    private static Map<String, Object> apis;

    public RESTQueryAPIAccessorImpl() {
        this.initializeProviderFactory();
    }

    private void initializeProviderFactory() {
        if (providerFactory == null) {
            providerFactory = ResteasyProviderFactory.getInstance();
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
            providerFactory.addStringConverter(BusinessArchiveStringConverter.class);
            providerFactory.addStringConverter(HashMapStringConverter.class);
            providerFactory.addStringConverter(MapStringConverter.class);
            providerFactory.addStringConverter(AttachementInstanceStringConverter.class);
            providerFactory.addStringConverter(ActivityInstanceStringConverter.class);
            providerFactory.addStringConverter(ActivityInstanceImplStringConverter.class);
            providerFactory.addStringConverter(GenericObjectStringConverter.class);
            providerFactory.addStringConverter(RuleStringConverter.class);
            providerFactory.addStringConverter(DateStringConverter.class);
            providerFactory.addStringConverter(ConnectorExecutionDescriptorStringConverter.class);
            providerFactory.registerProvider(GenericObjectProvider.class);
            providerFactory.registerProvider(OctectStreamProvider.class);
            providerFactory.registerProvider(RESTClientExecutionInterceptor.class);
            providerFactory.addClientErrorInterceptor((ClientErrorInterceptor)new BonitaClientErrorInterceptor());
        }
    }

    protected <T> T getRESTAccess(Class<T> clazz) {
        String restServerAddress = System.getProperty("org.ow2.bonita.rest-server-address");
        if (restServerAddress == null && LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("The property org.ow2.bonita.rest-server-address is null!");
        } else if (restServerAddress != null && LOG.isLoggable(Level.FINE)) {
            LOG.fine("org.ow2.bonita.rest-server-address: " + restServerAddress);
        }
        return RESTQueryAPIAccessorImpl.getAPISingleton(clazz, restServerAddress);
    }

    private static synchronized <T> T getAPISingleton(Class<T> clazz, String restServerAddress) {
        String key = clazz.getName() + restServerAddress;
        Object api = clazz.cast(apis.get(key));
        if (api == null) {
            api = ProxyFactory.create(clazz, (String)restServerAddress, (ClientExecutor)clientExecutor);
            RESTQueryAPIAccessorImpl.logGetAPIProxyResult(clazz, restServerAddress, key, true);
            apis.put(key, api);
        } else {
            RESTQueryAPIAccessorImpl.logGetAPIProxyResult(clazz, restServerAddress, key, false);
        }
        return api;
    }

    private static <T> void logGetAPIProxyResult(Class<T> clazz, String restServerAddress, String key, boolean found) {
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Serving class (");
            stb.append(clazz.getName());
            stb.append(") for url (");
            stb.append(restServerAddress);
            stb.append(") [key=");
            stb.append(key);
            stb.append("]: ");
            if (found) {
                stb.append("NOT FOUND YET, creating a new proxy...");
            } else {
                stb.append("FOUND.");
            }
            LOG.fine(stb.toString());
        }
    }

    @Override
    public BAMAPI getBAMAPI() {
        return this.getBAMAPI("queryList");
    }

    @Override
    public BAMAPI getBAMAPI(String queryList) {
        RemoteBAMAPI remoteBAMAPI = this.getRESTAccess(RemoteBAMAPI.class);
        return AccessorProxyUtil.getRemoteClientAPI(BAMAPI.class, remoteBAMAPI, queryList);
    }

    @Override
    public QueryDefinitionAPI getQueryDefinitionAPI() {
        return this.getQueryDefinitionAPI("queryList");
    }

    @Override
    public QueryDefinitionAPI getQueryDefinitionAPI(String queryList) {
        RemoteQueryDefinitionAPI remoteQueryRuntimeAPI = this.getRESTAccess(RemoteQueryDefinitionAPI.class);
        return AccessorProxyUtil.getRemoteClientAPI(QueryDefinitionAPI.class, remoteQueryRuntimeAPI, queryList);
    }

    @Override
    public QueryRuntimeAPI getQueryRuntimeAPI() {
        return this.getQueryRuntimeAPI("queryList");
    }

    @Override
    public QueryRuntimeAPI getQueryRuntimeAPI(String queryList) {
        RESTRemoteQueryRuntimeAPI remoteQueryRuntimeAPI = this.getRESTAccess(RESTRemoteQueryRuntimeAPI.class);
        return AccessorProxyUtil.getRemoteClientAPI(QueryRuntimeAPI.class, remoteQueryRuntimeAPI, queryList);
    }

    static {
        clientExecutor = new ApacheHttpClient4Executor((HttpClient)new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager()));
        apis = new HashMap<String, Object>();
    }
}

