/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebDeleteProcessCommand
implements Command<Void> {
    private static final long serialVersionUID = -4049500711900576134L;
    private ProcessDefinitionUUID processUUID;

    public WebDeleteProcessCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        Set<LightProcessInstance> instances = accessor.getQueryRuntimeAPI().getLightProcessInstances(this.processUUID);
        WebAPI webAPI = accessor.getWebAPI();
        HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
        for (LightProcessInstance instance : instances) {
            uuids.add(instance.getUUID());
            if (uuids.size() != 100) continue;
            webAPI.removeAllCasesFromLabels(uuids);
            uuids.clear();
        }
        webAPI.removeAllCasesFromLabels(uuids);
        accessor.getManagementAPI().deleteProcess(this.processUUID);
        return null;
    }
}

