/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.paging.ProcessInstanceCriterion;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebGetManageableLightParentProcessInstances
implements Command<List<LightProcessInstance>> {
    private static final long serialVersionUID = 4223637974438770807L;
    private final int fromIndex;
    private final int pageSize;
    private final boolean searchInHistory;
    private final String userID;
    private final Set<String> roleUUIDs;
    private final Set<String> groupUUIDs;
    private final Set<String> membershipUUIDs;
    private final String entityID;

    public WebGetManageableLightParentProcessInstances(int fromIndex, int pageSize, boolean searchInHistory, String userID, Set<String> userRoles, Set<String> userGroups, Set<String> userMemberships, String userName) {
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
        this.userID = userID;
        this.roleUUIDs = userRoles;
        this.groupUUIDs = userGroups;
        this.membershipUUIDs = userMemberships;
        this.entityID = userName;
    }

    @Override
    public List<LightProcessInstance> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        HashSet<String> exceptions = new HashSet<String>();
        List<Rule> applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_MANAGE, this.userID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy processStartPolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_MANAGE);
        switch (processStartPolicy) {
            case ALLOW_BY_DEFAULT: {
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    List<LightProcessInstance> result = queryRuntimeAPI.getLightParentProcessInstancesExcept(processUUIDs, this.fromIndex, this.pageSize, ProcessInstanceCriterion.DEFAULT);
                    return result;
                }
                return queryRuntimeAPI.getLightParentProcessInstances(this.fromIndex, this.pageSize);
            }
            case DENY_BY_DEFAULT: {
                if (processUUIDs.size() > 0) {
                    return queryRuntimeAPI.getLightParentProcessInstances(processUUIDs, this.fromIndex, this.pageSize, ProcessInstanceCriterion.DEFAULT);
                }
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException();
    }
}

