/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.runtime.event.EventCoupleHandling;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class CreateJobs
implements Command<Void> {
    private static final long serialVersionUID = -803942547334112806L;
    private final Set<EventCoupleId> eventCoupleIds;
    static final Logger LOG = Logger.getLogger(CreateJobs.class.getName());

    public CreateJobs(Set<EventCoupleId> eventCoupleIds) {
        this.eventCoupleIds = eventCoupleIds;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        for (EventCoupleId eventCoupleId : this.eventCoupleIds) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating job with eventCoupleId: " + eventCoupleId);
            }
            EventCoupleHandling.createJob(eventService, eventCoupleId);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateJob [eventCoupleIds=");
        builder.append(this.eventCoupleIds);
        builder.append("]");
        return builder.toString();
    }
}

