/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class EventCoupleHandling {
    private static final Logger LOG = Logger.getLogger(EventCoupleHandling.class.getName());

    public static EventCoupleId createEventCouple(IncomingEventInstance incoming, OutgoingEventInstance outgoing) {
        incoming.setLocked(true);
        outgoing.setLocked(true);
        long incomingId = incoming.getId();
        outgoing.setIncomingId(incomingId);
        EventCoupleId eventCoupleId = new EventCoupleId(incomingId, outgoing.getId());
        return eventCoupleId;
    }

    public static void createJob(EventService eventService, EventCoupleId eventCoupleId) {
        String rootUUID;
        IncomingEventInstance ie = eventService.getIncomingEvent(eventCoupleId.getIncoming());
        OutgoingEventInstance oe = eventService.getOutgoingEvent(eventCoupleId.getOutgoing());
        String eventPosition = null;
        String event = ie.getSignal();
        if (event.contains("start")) {
            eventPosition = "start";
        } else if (event.contains("boundary")) {
            eventPosition = "boundary";
        } else if (event.contains("intermediate")) {
            eventPosition = "intermediate";
        }
        ProcessInstanceUUID instanceUUID = ie.getInstanceUUID();
        if (instanceUUID != null) {
            InternalProcessInstance instance = EnvTool.getJournal().getProcessInstance(instanceUUID);
            rootUUID = instance.getRootInstanceUUID().getValue();
        } else {
            rootUUID = ie.getActivityDefinitionUUID().getProcessUUID().getValue();
        }
        Job job = new Job(ie.getName(), eventPosition, "message", rootUUID, ie.getExecutionUUID(), ie.getActivityDefinitionUUID(), null, System.currentTimeMillis(), instanceUUID);
        job.setEventSubProcessRootInstanceUUID(ie.getEventSubProcessRootInstanceUUID());
        if (!"start".equals(job.getEventPosition())) {
            eventService.removeEvent(ie);
        } else {
            ie.setLocked(false);
        }
        if (oe.getParameters().isEmpty()) {
            eventService.removeEvent(oe);
        } else {
            job.setOutgoingEvent(oe);
        }
        eventService.storeJob(job);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Job with eventCoupleId: " + eventCoupleId + " created.");
        }
    }
}

