/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Set;
import java.util.logging.Level;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.GetEventCouples;
import org.ow2.bonita.runtime.event.GetExpressionMessageEventCouples;
import org.ow2.bonita.runtime.event.GetNextEventDueDate;
import org.ow2.bonita.runtime.event.GetNextExpressionEventDueDate;
import org.ow2.bonita.runtime.event.RemoveOverdueEvents;
import org.ow2.bonita.runtime.event.SlicedEventExecutorThread;

public class EventMatcher
extends SlicedEventExecutorThread {
    private boolean matchingConditionEnable;
    private int maxCouples;

    EventMatcher(EventExecutor executor, String name) {
        super(executor, name);
    }

    @Override
    protected void activate() {
    }

    @Override
    protected void execute() {
        Set<EventCoupleId> coupleIds;
        this.getCommandService().execute(new RemoveOverdueEvents());
        do {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Getting couples...");
            }
            coupleIds = this.getCommandService().execute(new GetEventCouples(this.maxCouples));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.getClass().getSimpleName() + " on node " + System.getProperty("bonita.node.name") + " has got " + coupleIds.size() + " couples");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating jobs...");
            }
            this.storeJobs(coupleIds);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Jobs created.");
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("All couples handled, looping...");
        } while (coupleIds.size() == this.maxCouples);
        if (this.matchingConditionEnable) {
            Set<EventCoupleId> coupleIds2 = this.getCommandService().execute(new GetExpressionMessageEventCouples());
            this.storeJobs(coupleIds2);
        }
    }

    @Override
    protected String getJobExecutorName() {
        return "Correlation key message matcher";
    }

    @Override
    protected Long getNextDueDate() {
        Long dueDate1 = this.getCommandService().execute(new GetNextEventDueDate());
        if (this.matchingConditionEnable) {
            Long dueDate2 = this.getCommandService().execute(new GetNextExpressionEventDueDate());
            if (dueDate1 == null && dueDate2 == null) {
                return null;
            }
            if (dueDate1 != null && dueDate2 == null) {
                return dueDate1;
            }
            if (dueDate2 != null && dueDate1 == null) {
                return dueDate2;
            }
            return Math.min(dueDate1, dueDate2);
        }
        return dueDate1;
    }

    public void setMatchingConditionMatcher(boolean matchingConditionEnable) {
        this.matchingConditionEnable = matchingConditionEnable;
    }

    public void setMaxCouples(int maxCouples) {
        this.maxCouples = maxCouples;
    }
}

