/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.EventExecutorThread;
import org.ow2.bonita.runtime.event.ExecuteJobsCommand;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobExecutorThread;
import org.ow2.bonita.util.Command;

public abstract class JobExecutor
extends EventExecutorThread {
    private final int locksToQuery;
    private final int lockIdleTime;
    private final int nbrOfThreads;
    private final Map<String, Future<?>> runningThreads = new ConcurrentHashMap();
    private final Map<String, Long> lockedProcessUUIDs = new ConcurrentHashMap<String, Long>();
    private transient ThreadPoolExecutor threadPool;

    JobExecutor(EventExecutor executor, String name, int nbrOfThreads, int locksToQuery, int lockIdleTime) {
        super(executor, name);
        this.locksToQuery = locksToQuery;
        this.lockIdleTime = lockIdleTime;
        this.nbrOfThreads = nbrOfThreads;
        this.threadPool = new ThreadPoolExecutor(nbrOfThreads, nbrOfThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(nbrOfThreads), EventExecutor.EventRejectionHandler.INSTANCE);
    }

    @Override
    protected final void activate() {
    }

    public int getLockIdleTime() {
        return this.lockIdleTime;
    }

    public int getLocksToQuery() {
        return this.locksToQuery;
    }

    @Override
    public void deactivate(boolean join) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event executor: shutdown threadpool...");
        }
        this.threadPool.shutdown();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event executor: threadpool shutdowned.");
        }
        if (join) {
            try {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: waiting for threadPool termination...");
                }
                this.threadPool.awaitTermination(300000L, TimeUnit.MILLISECONDS);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: threadPool termination OK...");
                }
            }
            catch (InterruptedException e) {
                LOG.severe("joining got interrupted");
            }
        }
        super.deactivate(join);
    }

    protected abstract Command<List<String>> getNonlockedProcessUUIDsCommand(Set<String> var1);

    protected abstract boolean lockJob(String var1);

    protected abstract List<Job> getLockedJobs(String var1);

    protected abstract void releaseLock(String var1);

    protected void notifyThreadFinished(String processUUID) {
        this.runningThreads.remove(processUUID);
        this.refresh();
    }

    @Override
    protected void execute() throws InterruptedException {
        this.cleanRunningThreads();
        this.cleanLockedProcessUUIDs();
        List<String> nonLockedProcessUUIDs = this.getCommandService().execute(this.getNonlockedProcessUUIDsCommand(this.getProcessUUIDsToExclude()));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("On " + this.getJobExecutorName() + ", nonLockedProcessUUIDs(" + nonLockedProcessUUIDs.size() + ") = " + nonLockedProcessUUIDs);
        }
        if (nonLockedProcessUUIDs.size() > 0) {
            int availableThreads = this.nbrOfThreads - this.threadPool.getActiveCount() + this.nbrOfThreads * 3;
            int nbOfElementsTohandle = Math.min(availableThreads, nonLockedProcessUUIDs.size());
            ArrayList<String> processUUIDsToHandleInRandomOrder = new ArrayList<String>(nbOfElementsTohandle);
            if (nonLockedProcessUUIDs.size() < availableThreads) {
                processUUIDsToHandleInRandomOrder.addAll(nonLockedProcessUUIDs);
            } else {
                Random random = new Random(System.currentTimeMillis());
                for (int i = 0; i < nbOfElementsTohandle; ++i) {
                    String selectedUUID;
                    int indexToTake = random.nextInt(nonLockedProcessUUIDs.size());
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("On " + this.getJobExecutorName() + ", selecting a processUUID for thread nb (loop): " + i + ", indexToTake: " + indexToTake);
                    }
                    if (processUUIDsToHandleInRandomOrder.contains(selectedUUID = nonLockedProcessUUIDs.remove(indexToTake))) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("On " + this.getJobExecutorName() + ", adding processUUID for thread nb (loop): " + selectedUUID + " to list of processUUIDs to handle");
                    }
                    processUUIDsToHandleInRandomOrder.add(selectedUUID);
                }
            }
            List<String> processUUIDsToHandle = this.removeDuplicates(processUUIDsToHandleInRandomOrder);
            for (String processUUID : processUUIDsToHandle) {
                JobExecutorThread thread = new JobExecutorThread(this.getEventExecutor(), new ExecuteJobsCommand(this.getEventExecutor(), this, processUUID));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("On " + this.getJobExecutorName() + ", trying to process processUUID = " + processUUID);
                }
                Future<?> runningThread = this.threadPool.submit(thread);
                this.runningThreads.put(processUUID, runningThread);
            }
        }
    }

    private List<String> removeDuplicates(List<String> original) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : original) {
            if (result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    private void cleanRunningThreads() {
        ArrayList<String> processUUIDsToRemove = new ArrayList<String>();
        for (Map.Entry<String, Future<?>> runningThread : this.runningThreads.entrySet()) {
            if (!runningThread.getValue().isDone()) continue;
            processUUIDsToRemove.add(runningThread.getKey());
        }
        for (String processUUIDToRemove : processUUIDsToRemove) {
            this.runningThreads.remove(processUUIDToRemove);
        }
    }

    private void cleanLockedProcessUUIDs() {
        long now = System.currentTimeMillis();
        ArrayList<String> processUUIDsToRemove = new ArrayList<String>();
        for (Map.Entry<String, Long> lockedProcessUUID : this.lockedProcessUUIDs.entrySet()) {
            if (lockedProcessUUID.getValue() >= now) continue;
            processUUIDsToRemove.add(lockedProcessUUID.getKey());
        }
        for (String processUUIDToRemove : processUUIDsToRemove) {
            this.lockedProcessUUIDs.remove(processUUIDToRemove);
        }
    }

    protected Set<String> getProcessUUIDsToExclude() {
        HashSet<String> processUUIDsToExclude = new HashSet<String>();
        processUUIDsToExclude.addAll(this.runningThreads.keySet());
        processUUIDsToExclude.addAll(this.lockedProcessUUIDs.keySet());
        return processUUIDsToExclude;
    }

    protected void addLockedProcessUUID(String processUUID) {
        long now = System.currentTimeMillis();
        this.lockedProcessUUIDs.put(processUUID, now + (long)this.lockIdleTime);
    }
}

