/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;

public class DefaultCommandService
implements CommandService {
    static final Logger LOG = Logger.getLogger(DefaultCommandService.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        try {
            return command.execute(environment);
        }
        catch (RuntimeException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("exception while executing command " + command + ": " + e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("exception while executing command " + command + ": " + e.getMessage());
            }
            String message = ExceptionManager.getInstance().getFullMessage("bp_DCS_1 ", command);
            throw new BonitaRuntimeException(message, e, DefaultCommandService.class.getName());
        }
    }
}

