/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class LoggingInvocationHandler<T>
implements InvocationHandler {
    private final T target;
    private final Logger logger;

    public LoggingInvocationHandler(T target, Logger logger) {
        this.target = target;
        this.logger = logger;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.proxyToString();
        }
        if (method.getName().equals("equals") && args.length == 1) {
            return this.proxyEquals(proxy, args[0]);
        }
        String className = method.getDeclaringClass().getName();
        String methodName = method.getName();
        this.logger.entering(className, methodName, args);
        Object ret = method.invoke(this.target, args);
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    private Object proxyToString() {
        return "Proxy(" + this.target.toString() + ")";
    }

    private Object proxyEquals(Object proxy, Object object) {
        return proxy == object;
    }
}

