/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateJobsCommand
implements Command<Void> {
    private static final long serialVersionUID = -1279648441971721363L;
    private static final int MAX_RESULTS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(UpdateJobsCommand.class);

    @Override
    public Void execute(Environment environment) throws Exception {
        this.updateStartEventJobs();
        return null;
    }

    private void updateStartEventJobs() {
        LOG.info("updating jobs without process UUID ...");
        EventService eventService = EnvTool.getEventService();
        boolean fromIndex = false;
        List<Job> jobs = null;
        do {
            jobs = eventService.getJobsWithoutProcessUUID(0, 1000);
            this.updateJobs(jobs);
        } while (jobs != null && !jobs.isEmpty());
    }

    private void updateJobs(List<Job> jobs) {
        for (Job job : jobs) {
            if (job.getInstanceUUID() != null) {
                InternalProcessInstance instance = EnvTool.getJournal().getProcessInstance(job.getInstanceUUID());
                job.setProcessUUID(instance.getRootInstanceUUID().getValue());
                continue;
            }
            if (job.getActivityDefinitionUUID() != null) {
                InternalActivityDefinition activity = EnvTool.getJournal().getActivity(job.getActivityDefinitionUUID());
                job.setProcessUUID(activity.getProcessDefinitionUUID().getValue());
                continue;
            }
            throw new BonitaRuntimeException("Unable to set the process UUID for the job: " + job);
        }
    }
}

