/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core.configuration;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.connector.core.ConnectorDescription;
import org.ow2.bonita.connector.core.configuration.Parameter;

public class Configuration {
    private String id;
    private final List<Parameter> parameters;
    private final Configuration parent;
    private final List<Configuration> children;
    private final ConnectorDescription connector;

    public Configuration(String name, ConnectorDescription connector) {
        this.checkConfigurationName(name);
        if (connector == null) {
            throw new IllegalArgumentException("The connector cannot be null!");
        }
        this.id = name;
        this.parent = null;
        this.parameters = new ArrayList<Parameter>();
        this.children = new ArrayList<Configuration>();
        this.connector = connector;
    }

    public Configuration(String name, Configuration c) {
        if (c == null) {
            throw new IllegalArgumentException("The configuration cannot be null");
        }
        this.checkConfigurationName(name);
        if (this.exists(name, c.getRoot())) {
            throw new IllegalArgumentException("The configuration name has already been taken");
        }
        this.id = name;
        this.parameters = new ArrayList<Parameter>();
        this.parent = c;
        this.children = new ArrayList<Configuration>();
        c.children.add(this);
        this.connector = this.parent.connector;
    }

    public void checkConfigurationName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The configutration name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The configutration name cannot be empty");
        }
    }

    private boolean exists(String name, Configuration c) {
        if (name.equals(c.getId())) {
            return true;
        }
        for (Configuration child : c.children) {
            if (!this.exists(name, child)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.exists(id, this.getRoot())) {
            throw new IllegalArgumentException("The configuration name has already been taken");
        }
        this.id = id;
    }

    public void addParameter(Parameter element) {
        if (element == null) {
            throw new IllegalArgumentException("The parameter cannot be null!");
        }
        int index = this.containsParameter(element);
        if (index == -1) {
            this.parameters.add(element);
        } else {
            this.parameters.set(index, element);
        }
    }

    private int containsParameter(Parameter element) {
        return this.containsParameter(element, this.parameters);
    }

    private int containsParameter(Parameter element, List<Parameter> list) {
        int size = list.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            Parameter temp = list.get(i);
            if (!temp.getName().equals(element.getName())) continue;
            index = i;
            break;
        }
        return index;
    }

    public void removeParameter(Parameter element) {
        int index = this.containsParameter(element);
        if (index > -1) {
            this.parameters.remove(index);
        }
    }

    public List<Parameter> getLocalParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String parameterName) {
        return this.getParameter(this, parameterName);
    }

    public Parameter getParameter(Configuration c, String parameterName) {
        Parameter param = null;
        for (Parameter parameter : c.parameters) {
            if (!parameterName.equals(parameter.getName())) continue;
            param = parameter;
            break;
        }
        if (param == null && c.hasParent()) {
            param = this.getParameter(c.getParent(), parameterName);
        }
        return param;
    }

    public List<Parameter> getParameters() {
        return this.getParameters(this, new ArrayList<Parameter>());
    }

    private List<Parameter> getParameters(Configuration c, List<Parameter> list) {
        List<Parameter> parentParams = c.parameters;
        for (Parameter temp : parentParams) {
            if (this.containsParameter(temp, list) != -1) continue;
            list.add(temp);
        }
        if (c.hasParent()) {
            list = this.getParameters(c.getParent(), list);
        }
        return list;
    }

    private boolean hasParent() {
        boolean has = true;
        if (this.getParent() == null) {
            has = false;
        }
        return has;
    }

    public Configuration getParent() {
        return this.parent;
    }

    private Configuration getRoot() {
        return this.getRoot(this);
    }

    private Configuration getRoot(Configuration c) {
        if (c.hasParent()) {
            return this.getRoot(c.getParent());
        }
        return c;
    }

    public ConnectorDescription getConnectorDescription() {
        return this.connector;
    }

    public boolean equals(Object object) {
        Configuration temp;
        boolean equals = false;
        if (object instanceof Configuration && (temp = (Configuration)object).getId().equals(this.getId())) {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

